/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsPhysicalRow;
import ORG.as220.tinySQL.tsResultRow;
import ORG.as220.tinySQL.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class tsResultSet {
    public static final int ROWS_NOT_KNOWN = -1;
    private Vector rows;
    private int fetchsize;
    private int windowStart;
    private int level;
    private int rowsMax;
    private tinySQL dbengine;
    private int type;
    private boolean eof;
    private boolean hasReadResults;
    private tsPhysicalRow rowPrototype;
    private tsResultRow resultRowPrototype;
    private WhereClause whereC;
    private Hashtable tableColumns;
    private Vector tables;
    private tsResultRow resultRow;

    public tsResultSet(tsPhysicalRow row, Vector resultColumns, Hashtable tableColumns, WhereClause w, tinySQL dbeng) {
        this.rowPrototype = row;
        this.tableColumns = tableColumns;
        this.rows = new Vector();
        this.dbengine = dbeng;
        this.whereC = w;
        this.tables = new Vector();
        Enumeration tableEnum = tableColumns.keys();
        while (tableEnum.hasMoreElements()) {
            this.tables.add(tableEnum.nextElement());
        }
        this.type = 1003;
        this.hasReadResults = false;
        this.level = 0;
        this.rowsMax = -1;
        this.resultRowPrototype = new tsResultRow(resultColumns, row);
    }

    public tsResultSet(tsPhysicalRow row) {
        this.level = -1;
        this.rowPrototype = row;
        this.type = 1004;
        this.rows = new Vector();
        this.resultRowPrototype = new tsResultRow(row);
        this.rowsMax = -1;
    }

    public void setType(int type) {
        if (type == 1003 || type == 1005 || type == 1004) {
            this.type = type;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setFetchSize(int i) {
        this.fetchsize = i;
    }

    public int getFetchSize() {
        return this.fetchsize;
    }

    private boolean getMoreResults(int newPos, int fetchsize) throws tinySQLException {
        this.fetchsize = fetchsize;
        if (this.dbengine != null) {
            try {
                if (this.type != 1004) {
                    this.rows.clear();
                    this.windowStart = newPos;
                }
                this.level = this.dbengine.continueQuery(this);
                if (this.level > 0) {
                    this.eof = false;
                    return this.eof;
                }
                Log.debug("SELECT returned on level: " + this.level);
            }
            catch (tinySQLException e) {
                throw new tinySQLException("getMoreResults failed", e);
            }
        }
        this.eof = true;
        this.rowsMax = this.windowStart + this.rows.size();
        Log.debug("ResultSet: Max Rows reached: " + this.rowsMax);
        return this.eof;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public tsPhysicalRow createPhysicalRow() {
        return new tsPhysicalRow(this.rowPrototype);
    }

    public boolean addPhysicalRow(tsPhysicalRow row) {
        this.hasReadResults = true;
        tsResultRow addrsRow = new tsResultRow(this.resultRowPrototype);
        addrsRow.setParent(row);
        this.rows.add(addrsRow);
        return !(this.type == 1004 ? this.fetchsize > 0 && this.rows.size() >= this.fetchsize + this.windowStart : this.fetchsize > 0 && this.rows.size() >= this.fetchsize);
    }

    public int getLevel() {
        return this.level;
    }

    public WhereClause getWhereClause() {
        return this.whereC;
    }

    public int getColumnCount() {
        return this.resultRowPrototype.size();
    }

    public int findColumn(String name) throws tinySQLException {
        return this.resultRowPrototype.findColumn(name);
    }

    public Vector getTables() {
        return this.tables;
    }

    public Hashtable getColumns() {
        return this.tableColumns;
    }

    public int getCacheSize() {
        return this.rows.size();
    }

    public tsResultRow getResultRowAt(int row) throws tinySQLException {
        int i;
        if (row >= this.windowStart + this.rows.size()) {
            this.getMoreResults(row, this.fetchsize);
        }
        if ((i = row - this.windowStart) < this.rows.size()) {
            return (tsResultRow)this.rows.elementAt(i);
        }
        return null;
    }

    public tsColumn getColumnDefinition(int i) throws tinySQLException {
        return this.rowPrototype.getColumnDefinition(i);
    }

    public void close() {
        if (this.tables == null) {
            return;
        }
        Log.debug("ResultSet.close(): Closing " + this.tables.size() + " views");
        Enumeration enumeration = this.tables.elements();
        while (enumeration.hasMoreElements()) {
            tinySQLTableView table = (tinySQLTableView)enumeration.nextElement();
            try {
                table.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getResultSize() {
        return this.rowsMax;
    }
}

