/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.util;

import ORG.as220.tinySQL.util.CharEntityTable;
import ORG.as220.tinySQL.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CharacterEntityParser {
    private static CharacterEntityParser parser = null;
    private static Properties entities = null;
    private static Hashtable chars = null;

    private CharacterEntityParser() {
        entities = CharEntityTable.createTable();
        chars = new Hashtable();
        Log.debug("Entities.size " + ((Hashtable)entities).size());
        Enumeration enumeration = ((Hashtable)entities).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)((Hashtable)entities).get(key);
            Log.debug(key + " = " + value);
            chars.put(new Character(value.charAt(0)), key);
        }
    }

    public static String getCharacter(String key) {
        String val;
        if (parser == null) {
            parser = new CharacterEntityParser();
            Log.debug("Parser created: " + chars);
        }
        if ((val = entities.getProperty(key.toLowerCase())) == null) {
            return key;
        }
        return val;
    }

    public static String parseEntityValue(String value) {
        int parserIndex = 0;
        int subStart = 0;
        int subEnd = 0;
        int subValue = 0;
        String replaceString = null;
        StringBuffer bufValue = new StringBuffer(value);
        while ((subStart = value.indexOf("&", parserIndex)) != -1 && (subEnd = value.indexOf(";", parserIndex)) != -1) {
            parserIndex = subStart;
            StringBuffer buf = new StringBuffer();
            buf.append(bufValue.substring(subStart + 1, subEnd));
            if (buf.charAt(0) == '#') {
                buf.deleteCharAt(0);
                subValue = Integer.parseInt(buf.toString());
                if (subValue >= 1 && subValue <= 65536) {
                    char[] chr = new char[]{(char)subValue};
                    replaceString = new String(chr);
                }
            } else {
                replaceString = (String)((Hashtable)entities).get(buf.toString().toLowerCase());
            }
            if (replaceString != null) {
                replaceString = CharacterEntityParser.parseEntityValue(replaceString);
                bufValue.replace(subStart, subEnd + 1, replaceString);
                parserIndex += replaceString.length();
            }
            value = bufValue.toString();
        }
        return bufValue.toString();
    }

    public static String quoteString(String nat) {
        if (parser == null) {
            parser = new CharacterEntityParser();
            Log.debug("Parser created: " + chars);
        }
        StringBuffer retval = new StringBuffer(nat.length());
        int length = nat.length();
        int i = 0;
        while (i < length) {
            Character natC = new Character(nat.charAt(i));
            String quote = (String)chars.get(natC);
            if (quote == null) {
                retval.append(natC.charValue());
            } else {
                retval.append("&");
                retval.append(quote);
                retval.append(";");
            }
            ++i;
        }
        return retval.toString();
    }
}

