/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.util;

import java.io.PrintWriter;
import java.sql.DriverManager;

public class Log {
    private boolean logSystemOut;
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final String[] levels = new String[]{"ERROR: ", "WARN:  ", "INFO:  ", "DEBUG: "};
    private static int debuglevel = 100;

    private Log() {
    }

    public static void log(int level, String message) {
        if (level > 3) {
            level = 3;
        }
        if (level <= debuglevel) {
            DriverManager.println(levels[level] + message);
        }
    }

    public static void log(int level, String message, Exception e) {
        if (level > 3) {
            level = 3;
        }
        if (level <= debuglevel) {
            DriverManager.println(levels[level] + message);
            PrintWriter w = DriverManager.getLogWriter();
            if (w != null) {
                e.printStackTrace(w);
            }
        }
    }

    public static void debug(String message) {
        Log.log(3, message);
    }

    public static void debug(String message, Exception e) {
        Log.log(3, message, e);
    }

    public static void info(String message) {
        Log.log(2, message);
    }

    public static void info(String message, Exception e) {
        Log.log(2, message, e);
    }

    public static void warn(String message) {
        Log.log(1, message);
    }

    public static void warn(String message, Exception e) {
        Log.log(1, message, e);
    }

    public static void error(String message) {
        Log.log(0, message);
    }

    public static void error(String message, Exception e) {
        Log.log(0, message, e);
    }
}

