/*
 * Decompiled with CFR 0.152.
 */
import ORG.as220.tinySQL.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class QueryDbf {
    public static void main(String[] argv) {
        DriverManager.setLogStream(System.out);
        try {
            Class.forName("ORG.as220.tinySQL.dbfFileDriver").newInstance();
            String url = "jdbc:dbfFile:.";
            Properties p = new Properties();
            p.setProperty("user", "me");
            p.setProperty("encoding", "Cp850");
            p.setProperty("autoenc", "false");
            DriverManager.setLogStream(System.out);
            Connection con = DriverManager.getConnection(url, p);
            Statement stmt = con.createStatement();
            String str = null;
            str = argv.length == 1 ? argv[0] : "SELECT * FROM MALI";
            System.out.println("\nSQL: " + str + "\n");
            long startTime = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(str);
            System.out.println("ColCount: " + rs.getMetaData().getColumnCount());
            int numCols = QueryDbf.displayResults(rs);
            long endTime = System.currentTimeMillis();
            long diffTime = endTime - startTime;
            if (numCols > 0) {
                System.out.println("\n    -> Elapsed time: " + diffTime + " msecs [" + diffTime / (long)numCols + " msecs/tuple]");
            } else {
                System.out.println("\n    -> Elapsed time: " + diffTime + " msecs, no results found");
            }
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        System.exit(0);
    }

    static int displayResults(ResultSet rs) throws SQLException {
        if (rs == null) {
            System.err.println("ERROR in displayResult(): No data in ResulSet");
            return 0;
        }
        return Utils.printResultSet(rs, System.out);
    }

    public static String forceToSizeLeft(String str, int size, char padChar) {
        if (str != null && str.length() == size) {
            return str;
        }
        StringBuffer tmp = str == null ? new StringBuffer(size) : new StringBuffer(str);
        if (tmp.length() > size) {
            tmp.setLength(size);
            return tmp.toString();
        }
        int arsize = size - tmp.length();
        char[] ar = new char[arsize];
        int i = 0;
        while (i < arsize) {
            ar[i] = padChar;
            ++i;
        }
        tmp.append(ar);
        return tmp.toString();
    }
}

