/*
 * Decompiled with CFR 0.152.
 */
import ORG.as220.tinySQL.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TestDelete {
    static void executeUpdate(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        int res = stmt.executeUpdate(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs: " + res);
    }

    static ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        ResultSet rs = stmt.executeQuery(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs");
        rs.close();
        return rs;
    }

    public static void main(String[] argv) {
        try {
            Class.forName("ORG.as220.tinySQL.textFileDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("I could not find the tinySQL classes. Did you install\nthem as directed in the README file?");
            e.printStackTrace();
        }
        try {
            Properties p = new Properties();
            p.setProperty("user", "me");
            p.setProperty("encoding", "Cp850");
            p.setProperty("config.delete", "pack");
            DriverManager.setLogStream(System.out);
            Connection con = DriverManager.getConnection("jdbc:tinySQL:./test", p);
            Statement stmt = con.createStatement();
            TestDelete.executeUpdate(stmt, "DROP TABLE IF EXISTS party");
            System.out.println("");
            System.out.println("CREATE TABLE party ...");
            System.out.println("=====================");
            TestDelete.executeUpdate(stmt, "CREATE TABLE party (birthday DATE, age NUMERIC(10,0))");
            System.out.println("");
            System.out.println("INSERT INTO party ...");
            System.out.println("====================");
            TestDelete.executeUpdate(stmt, "INSERT INTO party (birthday, age) VALUES('2000-12-01', 1)");
            ResultSet res = stmt.executeQuery("SELECT * FROM party");
            Utils.printResultSet(res, System.out);
            System.out.println("");
            System.out.println("DELETE FROM party ...");
            System.out.println("====================");
            TestDelete.executeUpdate(stmt, "DELETE FROM party");
            res = stmt.executeQuery("SELECT * FROM party");
            Utils.printResultSet(res, System.out);
            stmt.close();
            con.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

