/*
 * Decompiled with CFR 0.152.
 */
import ORG.as220.tinySQL.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TestMDA {
    public static void executeUpdate(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        int res = stmt.executeUpdate(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs: " + res);
    }

    public static ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        ResultSet rs = stmt.executeQuery(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs");
        return rs;
    }

    public static void main(String[] argv) {
        try {
            Class.forName("ORG.as220.tinySQL.textFileDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("I could not find the tinySQL classes. Did you install\nthem as directed in the README file?");
            e.printStackTrace();
        }
        try {
            Properties p = new Properties();
            p.setProperty("user", "me");
            p.setProperty("separator", ";");
            p.setProperty("encoding", "Cp850");
            DriverManager.setLogStream(System.out);
            Connection con = DriverManager.getConnection("jdbc:tinySQL:./test", p);
            Statement stmt = con.createStatement();
            TestMDA.executeUpdate(stmt, "DROP TABLE IF EXISTS WowDepartments");
            System.out.println("");
            System.out.println("CREATE TABLE WowDepartments ...");
            System.out.println("=====================");
            TestMDA.executeUpdate(stmt, "CREATE TABLE WowDepartments (WowDeptNumber NUMERIC(3,0), WowDeptAbbr CHAR(10) NOT NULL, CpmDeptAbbr CHAR(3))");
            System.out.println("");
            System.out.println("INSERT INTO WowDepartments ...");
            System.out.println("====================");
            TestMDA.executeUpdate(stmt, "INSERT INTO WowDepartments SET WowDeptNumber=-12, WowDeptAbbr='URG CARE', CpmDeptAbbr='MED'");
            System.out.println("");
            System.out.println("SELECTING ALL FROM WowDepartments ...");
            System.out.println("====================");
            ResultSet res = stmt.executeQuery("SELECT WowDeptNumber FROM WowDepartments");
            Utils.printResultSet(res, System.out);
            res.close();
            System.out.println("");
            System.out.println("SELECTING WHERE WowDepartments ...");
            System.out.println("====================");
            res = stmt.executeQuery("SELECT WowDeptNumber FROM WowDepartments WHERE WowDeptAbbr = 'URG CARE'");
            Utils.printResultSet(res, System.out);
            res.close();
            stmt.close();
            con.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

