/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TestTextHtml {
    static void executeUpdate(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        int res = stmt.executeUpdate(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs: " + res);
    }

    static ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        System.out.println("  " + sql);
        long startTime = System.currentTimeMillis();
        ResultSet rs = stmt.executeQuery(sql);
        System.out.println("    -> Elapsed time: " + (System.currentTimeMillis() - startTime) + " msecs");
        return rs;
    }

    public static void main(String[] argv) {
        try {
            Class.forName("ORG.as220.tinySQL.textFileDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("I could not find the tinySQL classes. Did you install\nthem as directed in the README file?");
            e.printStackTrace();
        }
        try {
            Properties p = new Properties();
            p.setProperty("user", "me");
            p.setProperty("separator", ",");
            p.setProperty("encoding", "Cp850");
            p.setProperty("delete.prefix", "<!-- ");
            p.setProperty("delete.postfix", " -->");
            p.setProperty("column.prefix", "<td>");
            p.setProperty("column.postfix", "</td>");
            p.setProperty("row.prefix", "<tr>");
            p.setProperty("row.postfix", "</tr>\n");
            p.setProperty("table.prefix", "<html><body><table>");
            p.setProperty("table.postfix", "</table></body></html>");
            p.setProperty("definition-extension", ".def");
            p.setProperty("table-extension", ".html");
            DriverManager.setLogStream(System.out);
            Connection con = DriverManager.getConnection("jdbc:tinySQL:./test", p);
            Statement stmt = con.createStatement();
            TestTextHtml.executeUpdate(stmt, "DROP TABLE IF EXISTS cars");
            TestTextHtml.executeUpdate(stmt, "DROP TABLE IF EXISTS people");
            System.out.println("");
            System.out.println("CREATE TABLE cars ...");
            System.out.println("=====================");
            TestTextHtml.executeUpdate(stmt, "CREATE TABLE cars (name CHAR(25), id NUMERIC(4,0))");
            System.out.println("");
            System.out.println("CREATE TABLE people ...");
            System.out.println("=======================");
            TestTextHtml.executeUpdate(stmt, "CREATE TABLE people (pe_name CHAR(25), pe_id NUMERIC(8,0), car_id NUMERIC(4,0))");
            System.err.println("Created the tables.");
            System.out.println("");
            System.out.println("INSERT INTO cars ...");
            System.out.println("====================");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Fiat', 1)");
            TestTextHtml.executeUpdate(stmt, "insert into cars (name, id) values('Pinto', 2)");
            TestTextHtml.executeUpdate(stmt, "INSerT inTO cars (name, id) VALueS('Thing', 3)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Bug', 4)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Newport', 5)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Rangerover', 6)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Jeep', 7)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO cars (name, id) VALUES('Hummer', 8)");
            System.out.println("");
            System.out.println("INSERT INTO people ...");
            System.out.println("======================");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Irwin Garden', 1, 2)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Mr. Fiction', 2, 7)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Sal Paradise', 3, 8)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Dean Moriarty', 4, 3)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Bull Lee', 5, 7)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Jack Chip', 6, 1)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Glen Runciter', 7, 4)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Horselover Fat', 8, 2)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Gnossos Pappadopoulos', 9, 7)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Hef', 10, 6)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Matty Groves', 11, 7)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('Raoul Frodus', 12, 5)");
            TestTextHtml.executeUpdate(stmt, "INSERT INTO people (pe_name, pe_id, car_id) VALUES('H\u00e4gar Bo\u00df', 12, 5)");
            System.out.println("");
            System.out.println("UPDATE Mr. Garden ...");
            System.out.println("=====================");
            TestTextHtml.executeUpdate(stmt, "UPDATE people SET car_id=6 WHERE pe_name='Irwin Garden'");
            System.out.println("");
            System.out.println("SELECT cars, people ...");
            System.out.println("=======================");
            ResultSet rs = TestTextHtml.executeQuery(stmt, "SELECT pe_name, name FROM cars, people WHERE car_id = id");
            QueryDbf.displayResults(rs);
            rs.close();
            System.out.println("");
            System.out.println("Checking Meta data ...");
            System.out.println("======================");
            DatabaseMetaData dmd = con.getMetaData();
            System.out.println("");
            System.out.println("*** Type Info: [DATA_TYPE is from java.sql.Types]");
            rs = dmd.getTypeInfo();
            QueryDbf.displayResults(rs);
            rs.close();
            System.out.println("");
            System.out.println("*** Table Info:");
            String tableName = "%";
            rs = dmd.getTables(null, null, tableName, null);
            QueryDbf.displayResults(rs);
            rs.close();
            stmt.close();
            con.close();
            System.out.println("\nGood bye");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

