package jacorb.util;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.util.*;
import java.io.*;

/**
 * 
 * @author Gerald Brose
 * @version $Id: Debug.java,v 1.3 1999/11/25 16:08:21 brose Exp $
 */

public final class Debug
{
    private static Environment e= new Environment();
    private static int _verbosity = Environment.verbosityLevel();
    private static PrintWriter _log_file_out = Environment.logFileOut();

    public static final void output(int msg_level, String msg) 
    {	
	if (msg_level > _verbosity) return;		
	if (_log_file_out == null || msg_level == 0) 
	{
	    System.out.println("[ " + msg + " ]");
	} 
	if (_log_file_out != null) 
	{
	    _log_file_out.println("[ " + Environment.time() + "> " + msg + " ]");
	    _log_file_out.flush();
	}
    }

    public static void output(int msg_level,String name,byte bs[])
    {
	output(msg_level,name,bs,bs.length);
    }
	
    public static void output(int msg_level,String name,byte bs[],int len)
    {

	if (msg_level > _verbosity) return;
	System.out.print("\nHexdump ["+name+"] len="+len+","+bs.length);
	String chars="";
	for (int i=0; i<len; i++)
	{
	    if (0 == i%16)
	    {
		System.out.println(chars); chars="";
	    }
	    chars+=toAscii(bs[i]);
	    System.out.print(toHex(bs[i]));
	    if(3 == i%4 ) { chars+=" "; System.out.print(" "); }
	}
	System.out.println(chars);
    }

    public static final String toHex(byte b)
    {
	int n1 = (b & 0xff) / 16;
	int n2 = (b & 0xff) % 16;
	char c1 = (char)(n1>9 ? ('A'+(n1-10)) : ('0'+n1));
	char c2 = (char)(n2>9 ? ('A'+(n2-10)) : ('0'+n2));
	return ""+c1+c2+" ";
    }
	
    public static final char toAscii(byte b)
    {
	if (b>(byte)31 && b<(byte)127) return (char)b; else return '.';
    }
	
    public static final void output(int msg_level, Throwable e) 
    {
	if (msg_level > _verbosity) return;
		
	if (_log_file_out == null || msg_level == 0) 
	{
	    System.out.println("############################ StackTrace ############################");
	    e.printStackTrace(System.out);
	    System.out.println("####################################################################");
	} 
	if (_log_file_out != null)
	{
	    _log_file_out.println("############################ StackTrace ############################");
	    e.printStackTrace(_log_file_out);
	    _log_file_out.println("####################################################################");
	    _log_file_out.flush();			
	}
    }


    public static void printTrace(int msg_level)
    {
	if (msg_level > _verbosity) return;

	try
	{
	    throw new RuntimeException();
	}
	catch( Exception e )
	{
	    e.printStackTrace();
	}
    }
}




