/*------------------------------------------------------------------------------
Name:      ConnectQos.cpp
Project:   xmlBlaster.org
Copyright: xmlBlaster.org, see xmlBlaster-LICENSE file
Comment:   Implementation of ConnectQos (ConnectReturnQos ConnectQosData)
------------------------------------------------------------------------------*/

#include <util/qos/ConnectQos.h>
#include <util/Global.h>
#include <util/Constants.h>
#include <util/lexical_cast.h>
#include <util/Global.h>

namespace org { namespace xmlBlaster { namespace util { namespace qos {

using namespace std;
using namespace org::xmlBlaster::authentication;
using namespace org::xmlBlaster::util;
using namespace org::xmlBlaster::util::qos::storage;
using namespace org::xmlBlaster::util::qos::address;

/*---------------------------- ConnectQosData --------------------------------*/

ConnectQosData::ConnectQosData(Global& global, const string& user, const string& passwd, long publicSessionId)
    : global_(global),
      log_(global.getLog("org.xmlBlaster.util.qos")),
      securityQos_(global, user, passwd),
      sessionQos_(global, user, publicSessionId),
      ptp_(true),
      //addresses_(),
      //cbAddresses_(),
      clientQueueProperties_(),
      sessionCbQueueProperty_(global, Constants::RELATING_CALLBACK, ""),
      serverReferences_(),
      clientProperties_()
{
   clusterNode_      = false;
   duplicateUpdates_ = false;
   persistent_       = false;
   getAddress();      // Force creation, to read environment
   getCbAddress();    // Force creation, to read environment
}

ConnectQosData::ConnectQosData(const ConnectQosData& data)
    : global_(data.global_),
      log_(data.log_),
      securityQos_(data.securityQos_),
      sessionQos_(data.sessionQos_),
      //addresses_(data.addresses_),
      //cbAddresses_(data.cbAddresses_),
      clientQueueProperties_(data.clientQueueProperties_),
      sessionCbQueueProperty_(data.sessionCbQueueProperty_),
      serverReferences_(data.serverReferences_),
      clientProperties_()
{
   copy(data);
}

ConnectQosData& ConnectQosData::operator =(const ConnectQosData& data)
{
   copy(data);
   return *this;
}

bool ConnectQosData::getPtp() const
{
   return ptp_;
}

const string& ConnectQosData::getBoolAsString(bool val) const
{
   static const string _TRUE = "true";
   static const string _FALSE = "false";
   if (val) return _TRUE;
   else return _FALSE;
}

void ConnectQosData::setPtp(bool ptp)
{
   ptp_ = ptp;
}

void ConnectQosData::setSessionQos(const SessionQos& sessionQos)
{
   sessionQos_ = sessionQos;
}

SessionQos& ConnectQosData::getSessionQos() const
{
   return sessionQos_;
}

string ConnectQosData::getSecretSessionId() const
{
   return sessionQos_.getSecretSessionId();
}

string ConnectQosData::getUserId() const
{
   return sessionQos_.getAbsoluteName();
}

string ConnectQosData::getCallbackType() const
{
   return sessionCbQueueProperty_.getType();
}

void ConnectQosData::setSecurityQos(const SecurityQos& securityQos)
{
   securityQos_ = securityQos;
}

SecurityQos& ConnectQosData::getSecurityQos() const
{
   return securityQos_;
}

void ConnectQosData::setClusterNode(bool clusterNode)
{
   clusterNode_ = clusterNode;
}

bool ConnectQosData::isClusterNode() const
{
   return clusterNode_;
}

void ConnectQosData::setDuplicateUpdates(bool duplicateUpdates)
{
   duplicateUpdates_ = duplicateUpdates;
}

bool ConnectQosData::isDuplicateUpdates() const
{
   return duplicateUpdates_;
}

void ConnectQosData::addServerRef(const ServerRef& serverRef)
{
   serverReferences_.insert(serverReferences_.begin(), serverRef);
}

const vector<ServerRef> ConnectQosData::getServerReferences() const
{
   return serverReferences_;
}

ServerRef ConnectQosData::getServerRef()
{
   if (serverReferences_.empty()) {
      addServerRef(ServerRef(Global::getDefaultProtocol()));
   }
   return *(serverReferences_.begin());
}

// methods for queues and addresses ...

void ConnectQosData::setAddress(const Address& address)
{
   getClientQueueProperty().setAddress(address);
   //addresses_.insert(addresses_.begin(), address);
}

Address& ConnectQosData::getAddress()
{
   org::xmlBlaster::util::qos::address::AddressBase &ab = getClientQueueProperty().getCurrentAddress();
   return reinterpret_cast<Address&>(ab);
   /*
   if (addresses_.empty()) {
      setAddress(Address(global_));
   }
   return *(addresses_.begin());
   */
}

void ConnectQosData::addCbAddress(const CallbackAddress& cbAddress)
{
   sessionCbQueueProperty_.setCallbackAddress(cbAddress);
   //cbAddresses_.insert(cbAddresses_.begin(), cbAddress);
}

CallbackAddress& ConnectQosData::getCbAddress()
{
   org::xmlBlaster::util::qos::address::AddressBase &ab = sessionCbQueueProperty_.getCurrentCallbackAddress();
   return reinterpret_cast<CallbackAddress&>(ab);//sessionCbQueueProperty_.getCurrentCallbackAddress();
   //if (cbAddresses_.empty()) {
   //   addCbAddress(CallbackAddress(global_));
   //}
   //return *(cbAddresses_.begin());
}

void ConnectQosData::addClientQueueProperty(const ClientQueueProperty& prop)
{
   clientQueueProperties_.insert(clientQueueProperties_.begin(), prop);
}

ClientQueueProperty& ConnectQosData::getClientQueueProperty()
{
   if (clientQueueProperties_.empty()) {
      addClientQueueProperty(ClientQueueProperty(global_, ""));
   }
   return *(clientQueueProperties_.begin());
}

void ConnectQosData::setSessionCbQueueProperty(const CbQueueProperty& prop)
{
   sessionCbQueueProperty_ = prop;
}

CbQueueProperty& ConnectQosData::getSessionCbQueueProperty()
{
   return sessionCbQueueProperty_;
}

const ConnectQosData::ClientPropertyMap& ConnectQosData::getClientProperties() const
{
   return clientProperties_;
}


/**
 * @param persistent mark a message as persistent
 */
void ConnectQosData::setPersistent(bool persistent)
{
   persistent_ = persistent;
}

/**
 * @return true/false
 */
bool ConnectQosData::isPersistent() const
{
   return persistent_;
}

string ConnectQosData::dumpClientProperties(const string& extraOffset) const
{
   string ret = "";
   QosData::ClientPropertyMap::const_iterator iter = clientProperties_.begin();
   while (iter != clientProperties_.end()) {
      const ClientProperty& cp = (*iter).second;
      ret += cp.toXml(extraOffset);
      iter++;
   }
   return ret;
}

/**
 * Dump state of this object into a XML ASCII string.
 * <br>
 * @param extraOffset indenting of tags for nice output
 * @return internal state of the RequestBroker as a XML ASCII string
 */
string ConnectQosData::toXml(const string& extraOffset) const
{
   string offset = Constants::OFFSET + extraOffset;
   string offset2 = offset + Constants::INDENT;
   string indent = extraOffset+Constants::INDENT;
   string ret;
   ret += offset + string("<qos>");

   // <securityService ...
   ret += securityQos_.toXml(indent);
   ret += offset2 + string("<ptp>") + getBoolAsString(ptp_)  + string("</ptp>");

   if (isClusterNode())
      ret += offset2 + string("<clusterNode>") + getBoolAsString(isClusterNode()) + string("</clusterNode>");

   if (isDuplicateUpdates() == false)
      ret += offset2 + string("<duplicateUpdates>") + getBoolAsString(isDuplicateUpdates()) + string("</duplicateUpdates>");

   if (isPersistent())
      ret += offset + " <persistent/>";

   ret += sessionQos_.toXml(indent);

   {  // client queue properties 
      vector<ClientQueueProperty>::const_iterator
         iter = clientQueueProperties_.begin();
      while (iter != clientQueueProperties_.end()) {
         ret += (*iter).toXml(indent);
         iter++;
      }
   }

   ret += sessionCbQueueProperty_.toXml(indent);

   {  //serverReferences
      vector<ServerRef>::const_iterator
         iter = serverReferences_.begin();
      while (iter != serverReferences_.end()) {
         ret += (*iter).toXml(indent);
         iter++;
      }
   }

   ret += dumpClientProperties(offset2);

   ret += offset + string("</qos>");
   return ret;
}

}}}} // namespaces

