/*------------------------------------------------------------------------------
Name:      ReqListServlet.java
Project:   xmlBlaster.org
Copyright: xmlBlaster.org, see xmlBlaster-LICENSE file
Comment:   Collects all xml requirement files into the all.xml master file
Version:   $Id: ReqListServlet.java,v 1.6 2002/09/13 23:18:22 ruff Exp $
------------------------------------------------------------------------------*/
package org.xmlBlaster.util.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.jutils.log.LogChannel;


/*
 * Create html files from doc/requirement xml files on the fly. 
 */
public class ReqListServlet extends ReqBaseServlet
{
   private static final String ME               = "ReqListServlet";
   private LogChannel log;

  /**
   */
   public void init(ServletConfig conf) throws ServletException {
      super.init(conf);
      log = org.xmlBlaster.util.Global.instance().getLog("http");
   }

   /**
    */
   public void doRequest(HttpServletRequest request, HttpServletResponse response)
                       throws ServletException
   {
      try {

         String dir_s     = Util.getParameter(request,"dir",null);
         String xslFile   = Util.getParameter(request,"xsl",null);

         File dir = new File(dir_s);
         StringBuffer xmlData = new StringBuffer();

         File[] files = dir.listFiles(new MyFilenameFilter());

         xmlData.append("<?xml version='1.0' encoding='ISO-8859-1' ?>\n");
         xmlData.append("<!-- all.xml, generated by CollectXml.java -->\n");
         xmlData.append("<files>\n");
         xmlData.append("<dir>"+dir_s+"</dir>\n");
         log.info(ME, "Using dir=" + dir + ", xls=" + xslFile);
         for (int ii=0; ii<files.length; ii++) {
            xmlData.append("   <url>file:" + dir_s + "/" + files[ii].getName() + "</url>\n");
         }
         xmlData.append("</files>");
         log.info(ME, "Found " + files.length + " entries for requirement list.");
         xmlOutput( xmlData.toString(),dir_s, xslFile, response );
      }
      catch (Exception e) {
         log.error(ME, "Can't create requirement list: " + e.toString());
         return;
      }
   }

   private class MyFilenameFilter implements FilenameFilter
   {
      public MyFilenameFilter() {}
      public boolean accept(File dir, String name)
      {
         if (name.endsWith(".xml"))
            return true;
         return false;
      }

   }

}

