
package test.ui;


/**
 * This class was generated by a SmartGuide.
 *
 */

import test.framework.*;
import java.util.Vector;
import java.lang.reflect.*;

/**
 * A simple user interface to run tests.
 * Enter the name of a class with a suite method which should return
 * the tests to be run.
 * <pre>
 * Synopsis: java java.ui.TestRunner [TestCase]
 * </pre>
 * TestRunner takes as an optional argument the name of the testcase
 * class to be run.
 *
 */

public class TestRunner extends java.awt.Frame implements java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.MouseListener, java.awt.event.TextListener, java.awt.event.WindowListener, java.lang.Runnable {
	private java.util.Vector fExceptions;
	private Thread fRunner = null;
	private TestResult fTestResult = null;
	private Test fTestSuite = null;
	private TraceFrame fTraceFrame = null;
	private java.awt.Label ivjerrorLabel = null;
	private java.awt.Label ivjfailureLabel = null;
	private java.awt.List ivjFailureList = null;
	private java.awt.Label ivjLabel1 = null;
	private java.awt.Label ivjLabel3 = null;
	private java.awt.Label ivjLabel5 = null;
	private Logo ivjLogo1 = null;
	private java.awt.Label ivjNumberOfErrors = null;
	private java.awt.Label ivjNumberOfFailures = null;
	private java.awt.Label ivjNumberOfRuns = null;
	private java.awt.Panel ivjPanel1 = null;
	private java.awt.Panel ivjPanel2 = null;
	private java.awt.Button ivjQuitButton = null;
	private java.awt.Button ivjrun = null;
	private java.awt.Button ivjShowErrorButton = null;
	private TestStatus ivjStatusIndicator = null;
	private java.awt.TextField ivjStatusLine = null;
	private java.awt.TextField ivjSuiteField = null;
	private java.awt.Label ivjsuiteLabel = null;
	private java.awt.BorderLayout ivjTestRunnerBorderLayout = null;
	private java.awt.Label ivjtotalLabel = null;


/**
 * Constructor
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public TestRunner() {
	super();
	initialize();
}
/**
 * TestMonitor constructor comment.
 * @param title java.lang.String
 */
public TestRunner(String title) {
	super(title);
}
/**
 * This method was created by a SmartGuide.
 */
private void about ( ) {
	AboutDialog about = new AboutDialog(this);
	about.setModal(true);
	about.move(200, 200);
	about.setVisible(true);
}
/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getrun()) ) {
		conn1(e);
	}
	if ((e.getSource() == getShowErrorButton()) ) {
		conn3(e);
	}
	if ((e.getSource() == getSuiteField()) ) {
		conn6(e);
	}
	if ((e.getSource() == getQuitButton()) ) {
		conn7(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * This method was created by a SmartGuide.
 * @param fixture test.framework.Fixture
 */
public void addError (TestResult result, Test test, Throwable t) {
	getNumberOfErrors().setText(Integer.toString(result.testErrors()));
	appendFailure("Error", test, t);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param fixture Fixture
 */
public void addFailure (TestResult result, Test test, Throwable t) {
	getNumberOfFailures().setText(Integer.toString(result.testFailures()));
	appendFailure("Failure", test, t);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param kind java.lang.String
 * @param fixture test.framework.Fixture
 */
private void appendFailure ( String kind, Test test, Throwable t) {
	if (t.getMessage() != null)
		getFailureList().add(kind+": "+test+":"+t.getMessage());
	else
		getFailureList().add(kind+": "+test);
	fExceptions.addElement(t);
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void clearStatus ( ) {
	getStatusLine().setText("");
	return;
}
/**
 * conn0:  (TestRunner.window.windowClosing(java.awt.event.WindowEvent) --> TestRunner.dispose())
 * @param arg1 java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn0(java.awt.event.WindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		System.exit(0);
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn1:  (run.action.actionPerformed(java.awt.event.ActionEvent) --> TestRunner.runSuite()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.runSuite();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn14:  (ShowErrorButton.action.actionPerformed(java.awt.event.ActionEvent) --> TestMonitor.showErrorTrace()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn14(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showErrorTrace();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn2:  (SuiteField.text.textValueChanged(java.awt.event.TextEvent) --> TestRunner.suiteNameChanged()V)
 * @param arg1 java.awt.event.TextEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn2(java.awt.event.TextEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.suiteNameChanged();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn3:  (ShowErrorButton.action.actionPerformed(java.awt.event.ActionEvent) --> TestRunner.showErrorTrace()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn3(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showErrorTrace();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn3:  (FailureList.item.itemStateChanged(java.awt.event.ItemEvent) --> TestMonitor.listSelectionChanged()V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn3(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.listSelectionChanged();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn4:  (FailureList.item.itemStateChanged(java.awt.event.ItemEvent) --> TestRunner.listSelectionChanged()V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn4(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.listSelectionChanged();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn4:  (SuiteField.text.textValueChanged(java.awt.event.TextEvent) --> TestMonitor.suiteNameChanged()V)
 * @param arg1 java.awt.event.TextEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn4(java.awt.event.TextEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.suiteNameChanged();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn5:  (FailureList.mouse.mouseClicked(java.awt.event.MouseEvent) --> TestRunner.showErrorTrace()V)
 * @param arg1 java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn5(java.awt.event.MouseEvent arg1) {
	try {
		// user code begin {1}
		if (arg1.getClickCount() != 2)
			return;
		// user code end
		this.showErrorTrace();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn6:  (SuiteField.action.actionPerformed(java.awt.event.ActionEvent) --> TestRunner.runSuite()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn6(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.runSuite();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn7:  (QuitButton.action.actionPerformed(java.awt.event.ActionEvent) --> TestRunner.quit()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn7(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.quit();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * conn8:  (Logo1.mouse.mouseClicked(java.awt.event.MouseEvent) --> TestRunner.about()V)
 * @param arg1 java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn8(java.awt.event.MouseEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.about();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * This method was created by a SmartGuide.
 * @param fixture test.framework.Fixture
 */

public void endTest(TestResult result, Test test ) {
	setLabelValue(getNumberOfRuns(), result.runTests() );
	getStatusIndicator().step(result.wasSuccessful());
	return;
}
/**
 * Return the errorLabel property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label geterrorLabel() {
	if (ivjerrorLabel == null) {
		try {
			ivjerrorLabel = new java.awt.Label();
			ivjerrorLabel.setName("errorLabel");
			ivjerrorLabel.setText("Errors:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjerrorLabel;
}
/**
 * Return the failureLabel property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getfailureLabel() {
	if (ivjfailureLabel == null) {
		try {
			ivjfailureLabel = new java.awt.Label();
			ivjfailureLabel.setName("failureLabel");
			ivjfailureLabel.setText("Failures:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjfailureLabel;
}
/**
 * Return the FailureList property value.
 * @return java.awt.List
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.List getFailureList() {
	if (ivjFailureList == null) {
		try {
			ivjFailureList = new java.awt.List(6);
			ivjFailureList.setName("FailureList");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjFailureList;
}
/**
 * Return the Label1 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel1() {
	if (ivjLabel1 == null) {
		try {
			ivjLabel1 = new java.awt.Label();
			ivjLabel1.setName("Label1");
			ivjLabel1.setText("Progress:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel1;
}
/**
 * Return the Label3 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel3() {
	if (ivjLabel3 == null) {
		try {
			ivjLabel3 = new java.awt.Label();
			ivjLabel3.setName("Label3");
			ivjLabel3.setFont(new java.awt.Font("dialog", 1, 12));
			ivjLabel3.setText(".suite( )");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel3;
}
/**
 * Return the Label5 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel5() {
	if (ivjLabel5 == null) {
		try {
			ivjLabel5 = new java.awt.Label();
			ivjLabel5.setName("Label5");
			ivjLabel5.setText("Errors and Failures:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel5;
}
/**
 * Return the Logo1 property value.
 * @return test.ui.Logo
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private Logo getLogo1() {
	if (ivjLogo1 == null) {
		try {
			ivjLogo1 = new test.ui.Logo();
			ivjLogo1.setName("Logo1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLogo1;
}
/**
 * Return the NumberOfErrors property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getNumberOfErrors() {
	if (ivjNumberOfErrors == null) {
		try {
			ivjNumberOfErrors = new java.awt.Label();
			ivjNumberOfErrors.setName("NumberOfErrors");
			ivjNumberOfErrors.setFont(new java.awt.Font("dialog", 1, 12));
			ivjNumberOfErrors.setAlignment(java.awt.Label.LEFT);
			ivjNumberOfErrors.setText("10000");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjNumberOfErrors;
}
/**
 * Return the NumberOfFailures property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getNumberOfFailures() {
	if (ivjNumberOfFailures == null) {
		try {
			ivjNumberOfFailures = new java.awt.Label();
			ivjNumberOfFailures.setName("NumberOfFailures");
			ivjNumberOfFailures.setFont(new java.awt.Font("dialog", 1, 12));
			ivjNumberOfFailures.setText("10000");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjNumberOfFailures;
}
/**
 * Return the NumberOfRuns property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getNumberOfRuns() {
	if (ivjNumberOfRuns == null) {
		try {
			ivjNumberOfRuns = new java.awt.Label();
			ivjNumberOfRuns.setName("NumberOfRuns");
			ivjNumberOfRuns.setFont(new java.awt.Font("dialog", 1, 12));
			ivjNumberOfRuns.setText("10000");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjNumberOfRuns;
}
/**
 * Return the Panel1 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel1() {
	java.awt.GridBagConstraints constraintssuiteLabel = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsSuiteField = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsrun = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsLabel5 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsFailureList = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsShowErrorButton = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsStatusLine = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsPanel2 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsQuitButton = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsStatusIndicator = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsLogo1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsLabel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsLabel3 = new java.awt.GridBagConstraints();
	if (ivjPanel1 == null) {
		try {
			ivjPanel1 = new java.awt.Panel();
			ivjPanel1.setName("Panel1");
			ivjPanel1.setLayout(new java.awt.GridBagLayout());
			ivjPanel1.setBackground(java.awt.SystemColor.control);

			constraintssuiteLabel.gridx = 1; constraintssuiteLabel.gridy = 0;
			constraintssuiteLabel.gridwidth = 2; constraintssuiteLabel.gridheight = 1;
			constraintssuiteLabel.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintssuiteLabel.anchor = java.awt.GridBagConstraints.WEST;
			constraintssuiteLabel.weightx = 0.0;
			constraintssuiteLabel.weighty = 0.0;
			constraintssuiteLabel.ipadx = 4; 			constraintssuiteLabel.ipady = 4;
			constraintssuiteLabel.insets = new java.awt.Insets(0, 8, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getsuiteLabel(), constraintssuiteLabel);
			getPanel1().add(getsuiteLabel());

			constraintsSuiteField.gridx = 1; constraintsSuiteField.gridy = 2;
			constraintsSuiteField.gridwidth = 1; constraintsSuiteField.gridheight = 1;
			constraintsSuiteField.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsSuiteField.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsSuiteField.weightx = 1.0;
			constraintsSuiteField.weighty = 0.0;
			constraintsSuiteField.insets = new java.awt.Insets(0, 8, 0, 2);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getSuiteField(), constraintsSuiteField);
			getPanel1().add(getSuiteField());

			constraintsrun.gridx = 5; constraintsrun.gridy = 2;
			constraintsrun.gridwidth = 1; constraintsrun.gridheight = 1;
			constraintsrun.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsrun.anchor = java.awt.GridBagConstraints.WEST;
			constraintsrun.weightx = 0.0;
			constraintsrun.weighty = 0.0;
			constraintsrun.insets = new java.awt.Insets(0, 0, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getrun(), constraintsrun);
			getPanel1().add(getrun());

			constraintsLabel5.gridx = 1; constraintsLabel5.gridy = 10;
			constraintsLabel5.gridwidth = 2; constraintsLabel5.gridheight = 1;
			constraintsLabel5.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsLabel5.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsLabel5.weightx = 0.0;
			constraintsLabel5.weighty = 0.0;
			constraintsLabel5.ipadx = 4; 			constraintsLabel5.ipady = 4;
			constraintsLabel5.insets = new java.awt.Insets(0, 8, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getLabel5(), constraintsLabel5);
			getPanel1().add(getLabel5());

			constraintsFailureList.gridx = 1; constraintsFailureList.gridy = 12;
			constraintsFailureList.gridwidth = 4; constraintsFailureList.gridheight = 2;
			constraintsFailureList.fill = java.awt.GridBagConstraints.BOTH;
			constraintsFailureList.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsFailureList.weightx = 0.0;
			constraintsFailureList.weighty = 1.0;
			constraintsFailureList.insets = new java.awt.Insets(0, 8, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getFailureList(), constraintsFailureList);
			getPanel1().add(getFailureList());

			constraintsShowErrorButton.gridx = 5; constraintsShowErrorButton.gridy = 13;
			constraintsShowErrorButton.gridwidth = 1; constraintsShowErrorButton.gridheight = 1;
			constraintsShowErrorButton.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsShowErrorButton.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsShowErrorButton.weightx = 0.0;
			constraintsShowErrorButton.weighty = 0.0;
			constraintsShowErrorButton.insets = new java.awt.Insets(0, 0, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getShowErrorButton(), constraintsShowErrorButton);
			getPanel1().add(getShowErrorButton());

			constraintsStatusLine.gridx = 0; constraintsStatusLine.gridy = 15;
			constraintsStatusLine.gridwidth = 5; constraintsStatusLine.gridheight = 1;
			constraintsStatusLine.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsStatusLine.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsStatusLine.weightx = 1.0;
			constraintsStatusLine.weighty = 0.0;
			constraintsStatusLine.insets = new java.awt.Insets(8, 8, 8, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getStatusLine(), constraintsStatusLine);
			getPanel1().add(getStatusLine());

			constraintsPanel2.gridx = 1; constraintsPanel2.gridy = 8;
			constraintsPanel2.gridwidth = 4; constraintsPanel2.gridheight = 1;
			constraintsPanel2.fill = java.awt.GridBagConstraints.BOTH;
			constraintsPanel2.anchor = java.awt.GridBagConstraints.WEST;
			constraintsPanel2.weightx = 1.0;
			constraintsPanel2.weighty = 0.0;
			constraintsPanel2.insets = new java.awt.Insets(0, 0, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getPanel2(), constraintsPanel2);
			getPanel1().add(getPanel2());

			constraintsQuitButton.gridx = 5; constraintsQuitButton.gridy = 15;
			constraintsQuitButton.gridwidth = 1; constraintsQuitButton.gridheight = 1;
			constraintsQuitButton.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsQuitButton.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsQuitButton.weightx = 0.0;
			constraintsQuitButton.weighty = 0.0;
			constraintsQuitButton.insets = new java.awt.Insets(0, 0, 0, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getQuitButton(), constraintsQuitButton);
			getPanel1().add(getQuitButton());

			constraintsStatusIndicator.gridx = 1; constraintsStatusIndicator.gridy = 5;
			constraintsStatusIndicator.gridwidth = 4; constraintsStatusIndicator.gridheight = 1;
			constraintsStatusIndicator.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsStatusIndicator.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsStatusIndicator.weightx = 0.0;
			constraintsStatusIndicator.weighty = 0.0;
			constraintsStatusIndicator.insets = new java.awt.Insets(0, 8, 8, 8);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getStatusIndicator(), constraintsStatusIndicator);
			getPanel1().add(getStatusIndicator());

			constraintsLogo1.gridx = 5; constraintsLogo1.gridy = 5;
			constraintsLogo1.gridwidth = 1; constraintsLogo1.gridheight = 4;
			constraintsLogo1.anchor = java.awt.GridBagConstraints.NORTH;
			constraintsLogo1.weightx = 0.0;
			constraintsLogo1.weighty = 0.0;
			constraintsLogo1.insets = new java.awt.Insets(8, 4, 0, 0);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getLogo1(), constraintsLogo1);
			getPanel1().add(getLogo1());

			constraintsLabel1.gridx = 1; constraintsLabel1.gridy = 3;
			constraintsLabel1.gridwidth = 2; constraintsLabel1.gridheight = 1;
			constraintsLabel1.anchor = java.awt.GridBagConstraints.WEST;
			constraintsLabel1.weightx = 0.0;
			constraintsLabel1.weighty = 0.0;
			constraintsLabel1.insets = new java.awt.Insets(4, 8, 0, 4);
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getLabel1(), constraintsLabel1);
			getPanel1().add(getLabel1());

			constraintsLabel3.gridx = 2; constraintsLabel3.gridy = 2;
			constraintsLabel3.gridwidth = 1; constraintsLabel3.gridheight = 1;
			constraintsLabel3.anchor = java.awt.GridBagConstraints.WEST;
			constraintsLabel3.weightx = 0.0;
			constraintsLabel3.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel1().getLayout()).setConstraints(getLabel3(), constraintsLabel3);
			getPanel1().add(getLabel3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel1;
}
/**
 * Return the Panel2 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel2() {
	java.awt.GridBagConstraints constraintstotalLabel = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsNumberOfRuns = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintserrorLabel = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsNumberOfErrors = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsfailureLabel = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsNumberOfFailures = new java.awt.GridBagConstraints();
	if (ivjPanel2 == null) {
		try {
			ivjPanel2 = new java.awt.Panel();
			ivjPanel2.setName("Panel2");
			ivjPanel2.setLayout(new java.awt.GridBagLayout());

			constraintstotalLabel.gridx = 0; constraintstotalLabel.gridy = 0;
			constraintstotalLabel.gridwidth = 1; constraintstotalLabel.gridheight = 1;
			constraintstotalLabel.anchor = java.awt.GridBagConstraints.WEST;
			constraintstotalLabel.weightx = 0.0;
			constraintstotalLabel.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(gettotalLabel(), constraintstotalLabel);
			getPanel2().add(gettotalLabel());

			constraintsNumberOfRuns.gridx = -1; constraintsNumberOfRuns.gridy = -1;
			constraintsNumberOfRuns.gridwidth = 1; constraintsNumberOfRuns.gridheight = 1;
			constraintsNumberOfRuns.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsNumberOfRuns.weightx = 0.0;
			constraintsNumberOfRuns.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(getNumberOfRuns(), constraintsNumberOfRuns);
			getPanel2().add(getNumberOfRuns());

			constraintserrorLabel.gridx = -1; constraintserrorLabel.gridy = -1;
			constraintserrorLabel.gridwidth = 1; constraintserrorLabel.gridheight = 1;
			constraintserrorLabel.anchor = java.awt.GridBagConstraints.CENTER;
			constraintserrorLabel.weightx = 0.0;
			constraintserrorLabel.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(geterrorLabel(), constraintserrorLabel);
			getPanel2().add(geterrorLabel());

			constraintsNumberOfErrors.gridx = -1; constraintsNumberOfErrors.gridy = -1;
			constraintsNumberOfErrors.gridwidth = 1; constraintsNumberOfErrors.gridheight = 1;
			constraintsNumberOfErrors.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsNumberOfErrors.weightx = 0.0;
			constraintsNumberOfErrors.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(getNumberOfErrors(), constraintsNumberOfErrors);
			getPanel2().add(getNumberOfErrors());

			constraintsfailureLabel.gridx = -1; constraintsfailureLabel.gridy = -1;
			constraintsfailureLabel.gridwidth = 1; constraintsfailureLabel.gridheight = 1;
			constraintsfailureLabel.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsfailureLabel.weightx = 0.0;
			constraintsfailureLabel.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(getfailureLabel(), constraintsfailureLabel);
			getPanel2().add(getfailureLabel());

			constraintsNumberOfFailures.gridx = -1; constraintsNumberOfFailures.gridy = -1;
			constraintsNumberOfFailures.gridwidth = 1; constraintsNumberOfFailures.gridheight = 1;
			constraintsNumberOfFailures.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsNumberOfFailures.weightx = 0.0;
			constraintsNumberOfFailures.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(getNumberOfFailures(), constraintsNumberOfFailures);
			getPanel2().add(getNumberOfFailures());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel2;
}
/**
 * Return the QuitButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getQuitButton() {
	if (ivjQuitButton == null) {
		try {
			ivjQuitButton = new java.awt.Button();
			ivjQuitButton.setName("QuitButton");
			ivjQuitButton.setLabel("Quit");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjQuitButton;
}
/**
 * Return the run property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getrun() {
	if (ivjrun == null) {
		try {
			ivjrun = new java.awt.Button();
			ivjrun.setName("run");
			ivjrun.setEnabled(false);
			ivjrun.setLabel("Run");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjrun;
}
/**
 * Return the ShowErrorButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getShowErrorButton() {
	if (ivjShowErrorButton == null) {
		try {
			ivjShowErrorButton = new java.awt.Button();
			ivjShowErrorButton.setName("ShowErrorButton");
			ivjShowErrorButton.setEnabled(false);
			ivjShowErrorButton.setActionCommand("Show...");
			ivjShowErrorButton.setLabel("Show...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjShowErrorButton;
}
/**
 * Return the StatusIndicator property value.
 * @return test.ui.TestStatus
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private TestStatus getStatusIndicator() {
	if (ivjStatusIndicator == null) {
		try {
			ivjStatusIndicator = new test.ui.TestStatus();
			ivjStatusIndicator.setName("StatusIndicator");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStatusIndicator;
}
/**
 * Return the StatusLine property value.
 * @return java.awt.TextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextField getStatusLine() {
	if (ivjStatusLine == null) {
		try {
			ivjStatusLine = new java.awt.TextField();
			ivjStatusLine.setName("StatusLine");
			ivjStatusLine.setFont(new java.awt.Font("dialog", 1, 12));
			ivjStatusLine.setEditable(false);
			ivjStatusLine.setForeground(java.awt.Color.red);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStatusLine;
}
/**
 * Return the SuiteField property value.
 * @return java.awt.TextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextField getSuiteField() {
	if (ivjSuiteField == null) {
		try {
			ivjSuiteField = new java.awt.TextField();
			ivjSuiteField.setName("SuiteField");
			ivjSuiteField.setFont(new java.awt.Font("Dialog", 0, 12));
			ivjSuiteField.setColumns(40);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjSuiteField;
}
/**
 * Return the suiteLabel property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getsuiteLabel() {
	if (ivjsuiteLabel == null) {
		try {
			ivjsuiteLabel = new java.awt.Label();
			ivjsuiteLabel.setName("suiteLabel");
			ivjsuiteLabel.setText("Enter the name of the TestCase class:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjsuiteLabel;
}
/**
 * Return the TestRunnerBorderLayout property value.
 * @return java.awt.BorderLayout
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.BorderLayout getTestRunnerBorderLayout() {
	java.awt.BorderLayout ivjTestRunnerBorderLayout = null;
	try {
		/* Create part */
		ivjTestRunnerBorderLayout = new java.awt.BorderLayout();
		ivjTestRunnerBorderLayout.setVgap(0);
		ivjTestRunnerBorderLayout.setHgap(0);
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	};
	return ivjTestRunnerBorderLayout;
}
/**
 * Return the totalLabel property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label gettotalLabel() {
	if (ivjtotalLabel == null) {
		try {
			ivjtotalLabel = new java.awt.Label();
			ivjtotalLabel.setName("totalLabel");
			ivjtotalLabel.setAlignment(java.awt.Label.LEFT);
			ivjtotalLabel.setText("Runs:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjtotalLabel;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	this.addWindowListener(this);
	getrun().addActionListener(this);
	getSuiteField().addTextListener(this);
	getShowErrorButton().addActionListener(this);
	getFailureList().addItemListener(this);
	getFailureList().addMouseListener(this);
	getSuiteField().addActionListener(this);
	getQuitButton().addActionListener(this);
	getLogo1().addMouseListener(this);
}
/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	setName("TestRunner");
	setName("TestRunner");
	setLayout(getTestRunnerBorderLayout());
	setSize(405, 309);
	setTitle("Run Test Suite");
	this.add("Center", getPanel1());
	initConnections();
	// user code begin {2}
	resetCounters();
	// user code end
}
/**
 * Method to handle events for the ItemListener interface.
 * @param e java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void itemStateChanged(java.awt.event.ItemEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getFailureList()) ) {
		conn4(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * This method was created by a SmartGuide.
 */
private void listSelectionChanged ( ) {
	getShowErrorButton().setEnabled(getFailureList().getSelectedIndex() != -1);
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		test.ui.TestRunner aTestRunner = new test.ui.TestRunner();
		try {
			Class aCloserClass = Class.forName("uvm.abt.edit.WindowCloser");
			Class parmTypes[] = { java.awt.Window.class };
			Object parms[] = { aTestRunner };
			java.lang.reflect.Constructor aCtor = aCloserClass.getConstructor(parmTypes);
			aCtor.newInstance(parms);
		} catch (java.lang.Throwable exc) {};
		aTestRunner.move(200, 200);
		aTestRunner.setVisible(true);

	  if (args.length == 1) {
		  aTestRunner.setSuiteName(args[0]);
		  aTestRunner.runSuite();
	  }
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of java.awt.Frame");
	}
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseClicked(java.awt.event.MouseEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getFailureList()) ) {
		conn5(e);
	}
	if ((e.getSource() == getLogo1()) ) {
		conn8(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseEntered(java.awt.event.MouseEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseExited(java.awt.event.MouseEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mousePressed(java.awt.event.MouseEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseReleased(java.awt.event.MouseEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * This method was created by a SmartGuide.
 */
private void quit ( ) {
	System.exit(0);
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void reset ( ) {
	resetCounters();
	clearStatus();
	getStatusIndicator().reset();
	resetFailureList();
	fExceptions= new Vector(10);
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void resetCounters ( ) {
	setLabelValue(getNumberOfErrors(), 0);
	setLabelValue(getNumberOfFailures(), 0);
	setLabelValue(getNumberOfRuns(), 0);
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void resetFailureList ( ) {
	getShowErrorButton().setEnabled(false);
	getFailureList().removeAll();
	return;
}
/**
 * This method was created by a SmartGuide.
 */
public void run ( ) {
	getrun().setLabel("Stop");
	showInfo("Initializing...");
	reset();

	//
	// force a garbage collection so that the
	// test class is garbage collected and unloaded.
	// This is not necessary in a "dynamic" environment
	// like VAJ
	//
	String vendor= System.getProperty("java.vendor");
	if (vendor == null || !vendor.equals("IBM")) {
		showInfo("Garbage Collection...");
		Runtime.getRuntime().gc();
	}
	showInfo("Load Test Case...");
	String suiteClassName= getSuiteField().getText();
	Class fixtureClass= null;
	Method suiteMethod= null;
	String methodName= "suite";

	try {
		 fixtureClass= Class.forName(suiteClassName);
	} catch(Exception e) {
		runFailed("Class \""+suiteClassName+"\" not found");
		return;
	}

	try {
		suiteMethod= fixtureClass.getMethod(methodName, new Class[0]);
 	} catch(Exception e) {
		runFailed("Class \""+suiteClassName+"\" has no method named \""+methodName+"\"");
		return;
	}

	try {
		fTestSuite= (Test)suiteMethod.invoke(null, new Class[0]); // static method
	} catch(Exception e) {
		runFailed("Could not invoke the suite() method");
		return;
	}
	fTestResult= new UITestResult(this);
	int totalRuns= fTestSuite.countTestCases();
	getStatusIndicator().start(totalRuns);
	showInfo("Running...");

	long startTime= System.currentTimeMillis();
	fTestSuite.run(fTestResult);
	if (fTestResult.shouldStop())
			showStatus("Stopped");
	else {
		long endTime= System.currentTimeMillis();
		long runTime= endTime-startTime;
		showInfo("Finished: "+runTime/1000+"."+runTime%1000+" seconds");
	}
	fRunner= null;
	fTestSuite= null;
	fTestResult= null;
	getrun().setLabel("Run");
}
/**
 * This method was created by a SmartGuide.
 * @param message java.lang.String
 */
private void runFailed(String message) {
		showStatus(message);
		getrun().setLabel("Run");
		fRunner= null;
}
/**
 * This method was created by a SmartGuide.
 */
public void runSuite ( ) {
	if (fRunner != null) {
		fTestResult.stop();
		return;
	}
	fRunner= new Thread(this);
	fRunner.start();

	return;
}
/**
 * This method was created by a SmartGuide.
 * @param field java.awt.TextField
 * @param value int
 */
private void setLabelValue ( java.awt.Label label, int value) {
	//hack
	String text;
	if (value == 0)
		text= "    0";
	else
		text= Integer.toString(value);
	label.setText(text);
}
public void setSuiteName(String suite) {
	getSuiteField().setText(suite);
}
/**
 * This method was created by a SmartGuide.
 */
private void showErrorTrace ( ) {
	int index= getFailureList().getSelectedIndex();
	if (index == -1)
		return;

	Throwable t= (Throwable)fExceptions.elementAt(index);
	if (fTraceFrame == null) {
		fTraceFrame = new TraceFrame();
		fTraceFrame.move(100, 100);
   }
	fTraceFrame.showTrace(t);
	fTraceFrame.setVisible(true);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param status java.lang.String
 */
private void showInfo( String message) {
	getStatusLine().setFont(new java.awt.Font("dialog", 0, 12));
	getStatusLine().setForeground(java.awt.Color.black);
	getStatusLine().setText(message);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param status java.lang.String
 */
private void showStatus( String status) {
	getStatusLine().setFont(new java.awt.Font("dialog", 1, 12));
	getStatusLine().setForeground(java.awt.Color.red);
	getStatusLine().setText(status);
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void suiteNameChanged ( ) {
	getrun().setEnabled(getSuiteField().getText().length() != 0);
	clearStatus();
	return;
}
/**
 * Method to handle events for the TextListener interface.
 * @param e java.awt.event.TextEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void textValueChanged(java.awt.event.TextEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getSuiteField()) ) {
		conn2(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == this) ) {
		conn0(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeiconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowIconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowOpened(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
}