dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl This file contains autoconf macros used by jukebox. -*-sh-*-
dnl
dnl Copyright (C) 1997 Free Software Foundation, Inc.
dnl Copyright (C) 1999 Vadim Tkachenko <vt@freehold.crocodile.org>
dnl
dnl Authoritative source URL for this file is <http://freehold.crocodile.org/~vt/jukebox/acinclude.m4>

dnl These are the top-level macros provided:
dnl
dnl AC_PATH_JDK		Finds the JDK or accepts the location argument
dnl AC_PROG_JAVATOOL	Finds the JDK tool or accepts the location argument
dnl AC_PATH_JAVACLASS	Finds the jar file or directory with the classes or
dnl			accepts the location argument
dnl
dnl Also, there are others, but I wouldn't recommend to use them just for
dnl consistency sake (VT).

dnl Find the 'false program, I'll need it as a substitute later
dnl Result goes in FALSE
AC_DEFUN(AC_PROG_FALSE,
[
AC_PATH_PROG(FALSE,false,$PATH)
])

dnl Find the JDK
dnl Results go in JDK_HOME
dnl Also sets JAVA_PLATFORM to 1 for 1.1 and to 2 for 1.2
dnl See also AC_WITH_PLATFORM

AC_DEFUN(AC_PATH_JDK,
[

    AC_MSG_CHECKING([for JDK location (please wait)])

    dnl The order is: --with-jdk first, environment second, guessed value third.

    dnl This is a safe default. Could screw up on the security features, but
    dnl oh well, this is what --with-java2 is for.

    JAVA_PLATFORM="1"

    AC_ARG_WITH(jdk-home,
    [  --with-jdk-home=DIR     Where is your JDK root directory.],
    [

        # This stuff works if the command line parameter --with-jdk-home was
        # specified, so it takes priority rightfully.

	JDK_HOME=${withval}

	if ${TEST} ! -d "${JDK_HOME}" ; then
	    AC_MSG_ERROR(Not a directory: ${JDK_HOME})
	fi

	AC_MSG_RESULT(${JDK_HOME})

    ],
    [
        # This works if the parameter was NOT specified, so it's a good time
        # to see what the enviroment says.

        # Since Sun uses JAVA_HOME a lot, we check it first and ignore the
        # JDK_HOME, otherwise just use whatever JDK_HOME was specified.

        if ${TEST} -n "${JAVA_HOME}" ; then

            JDK_HOME=${JAVA_HOME}
        fi
    ])

    if ${TEST} -z "${JDK_HOME}" ; then

        # Oh well, nobody set neither JAVA_HOME nor JDK_HOME, have to guess

        # The following code is based on the code submitted by Henner Zeller
        # for ${srcdir}/src/scripts/package/rpm/ApacheJServ.spec

        # Two variables will be set as a result:
        #
        # JDK_HOME
        # JAVA_PLATFORM


        for JDK_PREFIX in \
    	    /usr/local \
    	    /usr/local/lib \
    	    /usr \
    	    /usr/lib \
            /opt  \
    	    /
        do
            for JAVA_PLATFORM in 3 2 1 ;
            do

                for subversion in .9 .8 .7 .6 .5 .4 .3 .2 .1 "" ;
                do
                    for VARIANT in java java- jdk jdk-;
                    do
                        GUESS="${JDK_PREFIX}/${VARIANT}1.${JAVA_PLATFORM}${subversion}"
dnl                        AC_MSG_CHECKING([${GUESS}])

                        if ${TEST} -d "${GUESS}/bin" \
                        && ${TEST} -d "${GUESS}/include" ; then

                            JDK_HOME="${GUESS}"
                            AC_MSG_RESULT([${GUESS}])
                            break
                        fi

                    done

                    if ${TEST} -n "${JDK_HOME}" ; then
                        break;
                    fi

                done

                if ${TEST} -n "${JDK_HOME}" ; then
                    break;
                fi

            done

            if ${TEST} -n "${JDK_HOME}" ; then
                break;
            fi

        done

        if ${TEST} -n "${JDK_HOME}" ; then

            dnl Just to have the messages looking uniformly

            AC_MSG_CHECKING(Java platform)
            AC_MSG_RESULT([guess ${JAVA_PLATFORM}])
        fi

    else

        AC_MSG_CHECKING(Java platform)

        AC_ARG_WITH(java-platform,
        [  --with-java-platform=VAL Force the Java platorm
                          (value is 1 for 1.1.x or 2 for 1.2.x or greater)],
        [
            dnl This requires a bit of tweaking to be handled properly, but
            dnl the default is good enough

            JAVA_PLATFORM="2"
        ])

        AC_MSG_RESULT(forced Java ${JAVA_PLATFORM})

    fi

if ${TEST} -z "${JDK_HOME}" ; then

    AC_MSG_ERROR([JDK home not found, please specify one with --with-jdk-home option (run ./configure --help for more options)])
fi

AC_SUBST(JDK_HOME)
AC_PROVIDE([$0])
])

dnl Find the  rmic program (so far useful only for EJBoss
dnl (http://www.ejboss.org/), but preserved because doesn't break anything and
dnl allows this file to be reused for Jserv, ECS, Jukebox and EJBoss.
dnl
dnl I guess I'd work on this one later. I don't like it, it's not generic (VT).

dnl Result goes in RMIC (bare location) and RMICX (with classpath and flag
dnl adjustments)

dnl The order is: --with-rmic first, environment second, guessed value third.

AC_DEFUN(AC_PROG_RMIC,
[
    AC_REQUIRE([AC_PATH_JDK])
    AC_REQUIRE([AC_PROG_FALSE])
    AC_MSG_CHECKING(rmic binary)

    AC_ARG_WITH(rmic,
    [  --with-rmic=prog        Java RMI compiler you want to use, if not the one from JDK],
    [
        if ${TEST} "$withval" = "yes" || ${TEST} "$withval" = "no" ; then
            AC_MSG_ERROR(You must specify the rmic binary as the parameter for --with-rmic)
        fi

        if ${TEST} ! -x "$withval" ; then
            AC_MSG_ERROR(Bad value for --with-rmic: $withval)
        fi
    ],
    [
        RMIC="${JDK_HOME}/bin/rmic"
        if ${TEST} ! -x "${RMIC}" ; then
            AC_MSG_ERROR(rmic binary not found in ${JDK_HOME})
        fi
    ])

    AC_MSG_RESULT(${RMIC})
    AC_SUBST(RMIC)
    AC_PROVIDE([$0])

    if ${TEST} "${JAVA_PLATFORM}" = "2" ; then
    	RMICX="${RMIC} -classpath \${TARGET_CLASSPATH}:${JDK_HOME}/jre/lib/rt.jar"
    else
    	RMICX="CLASSPATH=\${CLASSPATH}:\${TARGET_CLASSPATH}:${JDK_HOME}/lib/classes.zip ${RMIC}"
    fi

    AC_SUBST(RMICX)
])

dnl Locate the Java tool within a JDK tree or by --with-* option.

dnl First parameter is the name of the variable it goes to
dnl Second parameter is the name of the binary to look up
dnl Third parameter is the --help message (pay attention to alignment)
dnl If the forth parameter is present and the binary is not found, just
dnl substitute it with $FALSE and display a warning message instead of bailing
dnl out.

dnl Results go to $1 (bare location) and $1X (with classpath and flag
dnl adjustments).

AC_DEFUN(AC_PROG_JAVATOOL,
[
    AC_REQUIRE([AC_PATH_JDK])
    AC_REQUIRE([AC_PROG_FALSE])
    AC_MSG_CHECKING($2)

    AC_ARG_WITH($2,
    [  --with-$2=prog    $3 you want to use],
    [
        if ${TEST} "$withval" = "yes" || ${TEST} "$withval" = "no" ; then
            AC_MSG_ERROR([You must specify the $2 binary as the parameter for --with-$2])
        fi

        if ${TEST} ! -x "$withval" ; then
            AC_MSG_ERROR([Bad value for --with-$2: $withval])
        fi
        $1="${withval}"

        if ${TEST} -n "`${ECHO} ${withval}|${GREP} -i /jikes`" ; then
            JIKES="true"
        else
            JIKES="false"
        fi

    ],
    [
        $1="${JDK_HOME}/bin/$2"
        if ${TEST} ! -x "${$1}" ; then
            if ${TEST} -n "$4" ; then
                AC_MSG_WARN($4)
                $1=${FALSE}
            else
                AC_MSG_ERROR([$2 binary not found in ${JDK_HOME}])
            fi
        fi
    ])

    AC_MSG_RESULT(${$1})
    AC_SUBST([$1])

    AC_PROVIDE($1)

    dnl VT: This ugly bypass is here because autoconf complains about its
    dnl bug. In the future, I'll be checking it once in a while


    OPTION=$1
    OPTION="${OPTION}_OPT"

    if ${TEST} "${JAVA_PLATFORM}" = "2" && ${TEST} "${JIKES}" = "false" ; then
    	$1X="${$1} \${$OPTION} -classpath \${TARGET_CLASSPATH}"
    else
        if ${TEST} -z "${TCSETA}" && ${TEST} -r "${JDK_HOME}/lib/classes.zip" ; then
            TARGET_CLASSPATH="$TARGET_CLASSPATH:${JDK_HOME}/lib/classes.zip"
            TCSETA="true"
        fi

        dnl Why 'or'? And! On the other hand, I don't remember whether there
        dnl is an rt.jar in 1.1...

        if ${TEST} -z "${TCSETB}" && ${TEST} -r "${JDK_HOME}/jre/lib/rt.jar" ; then
            TARGET_CLASSPATH="$TARGET_CLASSPATH:${JDK_HOME}/jre/lib/rt.jar"
            TCSETB="true"
        fi

        $1X="CLASSPATH=\${CLASSPATH}:\${TARGET_CLASSPATH} ${$1} \${$OPTION}"
    fi

    AC_SUBST([$1X])
])

dnl Find the Java class set.

dnl The first parameter is the name of the variable it goes to
dnl The second parameter is a guessed location basename
dnl The third parameter defines a name of the class that has to be present
dnl in the target entity
dnl The forth parameter is a --help message
dnl If the fifth parameter is not empty, this package is optional.
dnl The output goes into $1_CLASSES

dnl FIXME: Look for the signature class in the ${CLASSPATH}

AC_DEFUN(AC_PATH_JAVACLASS,
[
    AC_MSG_CHECKING($1)

    dnl Find out if we have a parameter

    AC_ARG_WITH($1,
    [  --with-$1=DIR/JAR $4],
    [
        $1_CLASSES=$withval
    ],
    [
        dnl Guess

        $1_CLASSES="/usr/local/$2"
    ])

    dnl Find out if it exists at all

    if ${TEST} ! -e "${$1_CLASSES}" ; then
        if ${TEST} -z "$5" ; then
            AC_MSG_ERROR(Does not exist: '${$1_CLASSES}')
        else
            AC_MSG_RESULT(not found in ${$1_CLASSES})
        fi
    else

        dnl Transform the class name into the path name

        CLASS="`echo $3|${TR} "." "/"`.class"

        dnl Find out what it is

        if ${TEST} -d "${$1_CLASSES}" ; then

            dnl OK, so this is a directory.

            AC_PATH_SEARCHCLASS($1,${$1_CLASSES},${CLASS})

            if ${TEST} -z "${$1}" ; then

                AC_PATH_SEARCHJAR($1,${$1_CLASSES},${CLASS})

                if ${TEST} -z "${$1}" ; then
                    if ${TEST} -z "$5" ; then
                        AC_MSG_ERROR([no $3 class or jar with it in ${$1_CLASSES}])
                    else
                        AC_MSG_RESULT(not found)
                    fi
                fi
            fi
        else

            AC_PATH_VERIFYJAR($1,${$1_CLASSES},${CLASS})

            if ${TEST} -z "${$1}" ; then
                AC_MSG_ERROR([$3 not found in ${$1_CLASSES}])
            fi
        fi
    fi

    $1_CLASSES=${$1}

    if ${TEST} -n "${$1_CLASSES}" ; then
        AC_MSG_RESULT([${$1_CLASSES}])
    fi
    AC_SUBST($1_CLASSES)
    AC_PROVIDE($1_CLASSES)

    dnl It appears that it's not possible to use the substitution in AM_CONDITIONAL,
    dnl so by now it's required to use it in configure.in, unfortunately.

    dnl AM_CONDITIONAL($1,${TEST} -n "${$1_CLASSES}")
])

dnl This one verifies if the $3 class exists in the $2 jar file and places
dnl the $2 in $1 if it is, otherwise sets it to empty string.

AC_DEFUN(AC_PATH_VERIFYJAR,
[
    if ${TEST} -z "${JAR}" ; then

        dnl This happens when you try to call AC_PATH_VERIFYJAR *before* defining JAR.
        dnl Modify your configure.in to include AC_PATH_JAVATOOL(JAR) above the invocation of,
        dnl most likely, AC_PATH_JAVACLASS.

        AC_MSG_ERROR([Find this string in acinclude.m4 and read the comments])
    fi

    dnl You may want to call it before, just to make the output look good

    $1=`${JAR} -tvf $2 2>&1|${GREP} $3`

    if ${TEST} -n "${$1}" ; then
    	$1=$2
    else
        $1=""
    fi
    AC_SUBST($1)
])

dnl Find a $3 class file in the $2 directory.
dnl If the directory is a classpath root, return it in $1.
dnl If it is not, but the class is there, bail out.
dnl If it doesn't contain the class file at all, return the empty string.

# IMPORTANT: Don't replace 'cd' with '${CD}. Reason: at least on Solaris, it
# breaks the behavior by treating ${CD} as an executable program, and
# consequently RETURNING TO THE CURRENT DIRECTORY after ${CD} is executed.

AC_DEFUN(AC_PATH_SEARCHCLASS,
[
    PRESENT=`(cd $2 && ${FIND} . -name "*.class"|${GREP} "$3"|${CUT} -c 3-)`

    if ${TEST} -n "${PRESENT}" ; then

        PRESENT=`echo ${PRESENT}|${GREP} -x "${CLASS}"`

        if ${TEST} -z "${PRESENT}" ; then

            dnl OK, here's a misajustment - let's try to fix it later by
            dnl calculating the length difference, so far - error

            AC_MSG_ERROR([$2 is not a classpath root for $3 - adjust it])
        else
            $1=$2
        fi
    fi

    AC_SUBST($1)
])

dnl Find all the jar and zip files below $2 and check them for $3 class until found.
dnl Bail out if there's no file in there.
dnl If the jar/zip is found, return it in $1.

dnl (VT: looks like AC_PATH_VERIFYJAR, may be just use it?)

AC_DEFUN(AC_PATH_SEARCHJAR,
[
    JARS=`${FIND} $2 \( -name "*.jar" -o -name "*.zip" \) -print|tr "\n" " "`

    if ${TEST} -n "$JARS" ; then
        for JARFILE in ${JARS} ; do
dnl            AC_MSG_CHECKING('$JARFILE' for $3)
            PRESENT=`${JAR} -tf ${JARFILE} 2>&1|${GREP} $3`
            
dnl            AC_MSG_RESULT(Got '${PRESENT}')
            
            if ${TEST} -n "${PRESENT}" ; then
                $1=${JARFILE}
                AC_SUBST($1)
                break
            fi
        done
    fi
])

dnl This one displays one-line summary on the optional jar/class component,
dnl if the correspondend environment variable is set.
dnl
dnl First parameter is the environment variable name, without _CLASSES appended.

AC_DEFUN(AC_REPORT_OPTIONAL, [

    if ${TEST} -n "${$1_CLASSES}" ; then
        AC_MSG_RESULT($1 (optional) used: ${$1_CLASSES})
    else
        AC_MSG_RESULT($1: (optional) not used)
    fi
])

AC_DEFUN(AC_PATH_EXTRA,
[
    if ${TEST} -n "${$1_CLASSES}" ; then
        TARGET_CLASSPATH="${TARGET_CLASSPATH}:${$1_CLASSES}"
    fi
])

AC_DEFUN(CHECK_GNU_MAKE,[ 
    AC_CACHE_CHECK([for GNU make], _cv_gnu_make_command, [ 
       ifGNUmake='#' ; 
       _cv_gnu_make_command='' ;
       if ${TEST} -x ${MAKE} ; then
           if ( ${MAKE} --version 2> /dev/null | ${GREP} GNU ) ; then 
               _cv_gnu_make_command=${MAKE} ; 
               ifGNUmake='' ;
           fi
       fi
       if ${TEST} -n "${ifGNUmake}" ; then
          AC_MSG_ERROR([
Found: ${MAKE}
GNU make is required and was not found. If GNU make is not installed,
please install it. www.gnu.org. If GNU make is installed, please adjust 
your PATH to make sure that GNU make is found before any other version
of make that is installed on your system. rm config.cache and then 
re-run configure again.])
       fi
    ]) 
])
dnl Most of this borrowed from the mico m4 libaray ac_pkg_mico.m4 available
dnl from http://research.cys.de/autoconf-archive.
dnl and was written by  Tal Shalif <tal@shalif.com>
dnl
dnl @synopsis AC_PKG_XERCESC([X.X.X optional required])
dnl
dnl This file was created for the xmlBlaster project http://www.xmlBlaster.org
dnl
dnl This macro searches for a xerces-c installation on your system.
dnl xerces-cinstalls the file 'XercesDefs.hpp' under
dnl XERCESC_INSTALL_BASE/util, where XERCESC_INSTALL_BASE is probably
dnl /usr/local or /usr. If nothing was specified when calling configure
dnl or just --with-xerces-c, it searches in $prefix/util:/usr/local/util:/usr/util
dnl The argument of --with-xerces-c specifies the base pathname of the
dnl xerces-c installation. For instance --with-xerces-c=/usr/local/xerces-c-1.4.0
dnl
dnl If the version argument is given (e.g. 1.4.0), AC_PKG_XERCESC checks that the
dnl xerces-c package is this version number or higher.
dnl
dnl The other optional argument to AC_PKG_XERCESC are 'optional' and 'required'.
dnl by default, placing AC_PKG_XERCESC in your configure.in does not enforce
dnl using xerces-c, if it is not found on the system. If XERCESC existence is
dnl critical for the building of your package, then you probably want
dnl to specify something like "AC_PKG_XERCESC(1.4.0 required)". Then, even
dnl if the --with-xerces-c was not spcefied on the command line of the
dnl configure script, an error will be raised if xerces-c was not found.
dnl
dnl If the xerces-c package is not found, abort configuration with error
dnl message.
dnl
dnl It defines the symbol XERCESCDIR, XERCESCVERSION, XERCESC_INCLUDE, and
dnl XERCESC_LIB.
dnl
dnl Example of use of these variables in your Makefile.in:
dnl
dnl   INCLUDES += @XERCESC_INCLUDE@
dnl   LDFLAGS += @XERCESC_LIB@
dnl
dnl Author: Cory Bennett <coryb@sgi.com>


AC_DEFUN([AC_PKG_XERCESC],
[
#
# first parse the argument given in configure.in to AC_PKG_XERCESC
#
XERCESC_REQUEST_VERSION=
XERCESC_URGENCY="optional"

changequote(<<, >>)

for a in $1 $2 $3 $4 $5 $6 $7 $8 $9 x; do
    case "$a" in
        x) break;;
        [0-9]*.[0-9]*.[0-9]*) XERCESC_REQUEST_VERSION="$a";;
        optional|required) XERCESC_URGENCY="$a";;
        *) AC_MSG_ERROR("argument to the PKG_XERCESC macro must be one of 'X.X.X' 'required' or 'optional'");;
    esac
done

changequote([, ])

AC_MSG_CHECKING(if xerces-c is wanted)
AC_ARG_WITH(xerces-c,
    [  --with-xerces-c=DIR     base path name of xerces-c's installation (default is
                          to search in \$prefix:/usr/local:/usr),
  --without-xerces-c      to disable xerces-c detection],
    [
    #
    # Run this if -with or -without was specified
    #
    case "$withval" in
        yes) XERCESC_URGENCY=required;;
        no) if test x$XERCESC_URGENCY = xrequired; then
                AC_MSG_ERROR("PKG_XERCESC was configured with the 'required' option. You can not override it from the command line")
            fi;
            ;;
        *) XERCESC_URGENCY=required; XERCESCDIR="$withval"; XERCESC_DEF="$withval/util/XercesDefs.hpp" ;;
    esac

    ],[])

AC_MSG_RESULT($XERCESC_URGENCY)

#
# Now we know if we want xerces-c or not, only go further if
# it's wanted.
#
if test x$XERCESC_URGENCY = xrequired -o  x$XERCESC_URGENCY = xoptional; then
    #
    # If not specified by caller, search in standard places
    #
    if test -z "$XERCESC_DEF" ; then
      AC_PATH_PROG(XERCESC_DEF, XercesDefs.hpp, , $prefix/util:/usr/local/util:/usr/util)
      #
      # try to figure out the full path now.
      #
      XERCESCDIR="`echo \"$XERCESC_DEF\" | sed 's/\/util\/XercesDefs.hpp//'`"
      AC_MSG_RESULT( "xerces-c dir is $XERCESCDIR" )     
    else
      #
      # This is just to print out what we are doing
      # It does not actually do anything
      #
      AC_MSG_CHECKING(for XercesDefs.hpp)
      AC_MSG_RESULT($XERCESC_DEF)
    fi
    
    if test -z "$XERCESC_DEF" || ! test -f "$XERCESC_DEF"; then
        if test x$XERCESC_URGENCY = xrequired ; then
            AC_MSG_ERROR([xerces-c defs file XercesDefs.hpp not found,
use option --with-xerces-c=DIR if it is installed on your system.
If it is not installed on you system, then you can download it 
from http://xml.apache.org])
        else
            AC_MSG_RESULT("xerces-c defs file XercesDefs.hpp not found")
        fi
    else
        changequote(<<, >>)dnl
        XERCESCVERSION="`grep gXercesFullVersionStr $XERCESC_DEF | sed 's/^.*\"\([0-9][_0-9]*\).*$/\1/' | sed 's/_/./g'`"
        changequote([, ])dnl
        AC_MSG_RESULT( "Xerces-c Version is $XERCESCVERSION" )
        
        if test -z "$XERCESCVERSION" ; then
            AC_MSG_ERROR("panic: could not read the XERCESCVERSION variable");
        fi
        #
        # Check that xerces-c version matches requested version or above
        #
        if test -n "$XERCESC_REQUEST_VERSION" ; then
            changequote(<<, >>)dnl
            XERCESC_MAJOR=`expr $XERCESCVERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            XERCESC_MINOR=`expr $XERCESCVERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            XERCESC_RELEASE=`expr $XERCESCVERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            XERCESC_REQUEST_MAJOR=`expr $XERCESC_REQUEST_VERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            XERCESC_REQUEST_MINOR=`expr $XERCESC_REQUEST_VERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            XERCESC_REQUEST_RELEASE=`expr $XERCESC_REQUEST_VERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            changequote([, ])dnl

            AC_MSG_CHECKING(xerces-c version >= $XERCESC_REQUEST_VERSION)

            version_ok=yes
            for verpair in "$XERCESC_MAJOR:$XERCESC_REQUEST_MAJOR" "$XERCESC_MINOR:$XERCESC_REQUEST_MINOR" "$XERCESC_RELEASE:$XERCESC_REQUEST_RELEASE"; do
                if eval "test `echo $verpair | sed 's,:, -gt ,'`"; then
                    break
                fi
                if eval "test `echo $verpair | sed 's,:, -lt ,'`"; then
                    version_ok=no
                    break
                fi
            done
            if test  x$version_ok = xno; then
                AC_MSG_RESULT(no)
                AC_MSG_ERROR(xerces-c version is $XERCESCVERSION)
            else
                AC_MSG_RESULT(yes)
            fi
        fi

        AC_MSG_CHECKING(how to link with the xerces-c library)

        changequote(<<, >>)dnl
        XERCESC_DLL_VERSION="`grep Xerces_DLLVersionStr $XERCESC_DEF | sed 's/^.*\"\([0-9][_0-9]*\).*$/\1/'`"
        changequote([, ])dnl
        if test ! -f "${XERCESCDIR}/lib/libxerces-c${XERCESC_DLL_VERSION}.so"; then
            AC_MSG_ERROR([xerces-c library libxerces-c${XERCESC_DLL_VERSION}.so not found])
        fi
        
        XERCESC_LIB="-L${XERCESCDIR}/lib -lxerces-c${XERCESC_DLL_VERSION} -lpthread"
        AC_MSG_RESULT($XERCESC_LIB)
        
        XERCESC_INCLUDE="-I$XERCESCDIR"
        
        AC_SUBST(XERCESCDIR)
        AC_SUBST(XERCESCVERSION)
        AC_SUBST(XERCESC_INCLUDE)
        AC_SUBST(XERCESC_LIB)
    fi
fi
])
dnl Taken from the autoconf archives @ http://research.cys.de/autoconf-archive/
dnl Original file name: ac_pkg_mico.m4
dnl Modified slightly to check for qt mico library.  Added MICO_QTLIB macro
dnl which is used instead of MICO_LIB whenever you want both -lmico & -lmicoqt 
dnl @synopsis AC_PKG_MICO([X.X.X optional required])
dnl
dnl This macro searches for a MICO installation on your system.
dnl MICO (Mico Is COrba) installs the file 'mico-setup.sh' under
dnl MICO_INSTALL_BASE/lib, where MICO_INSTALL_BASE is probably
dnl /usr/local or /usr. If nothing was specified when calling configure
dnl or just --with-mico, it searches in $prefix/lib:/usr/local/lib:/usr/lib
dnl The argument of s--with-mico specifies the full pathname of the
dnl mico-setup.sh file. For instance --with-mico=/usr/local/mico-2.2.6/lib/mico-setup.sh.
dnl
dnl Change: I just modified this to not have to include the lib/mico-setup.sh
dnl
dnl If the version argument is given (e.g. 2.2.6), AC_PKG_MICO checks that the
dnl mico package is this version number or higher.
dnl
dnl The other optional argument to AC_PKG_MICO are 'optional' and 'required'.
dnl by default, placing AC_PKG_MICO in your configure.in does not enforce
dnl using mico, if it is not found on the system. If MICO existence is
dnl critical for the building of your package, then you probably want
dnl to specify something like "AC_PKG_MICO(2.2.6 required)". Then, even
dnl if the --with-mico was not spcefied on the command line of the
dnl configure script, an error will be raised if mico was not found.
dnl
dnl If the mico package is not found, abort configuration with error
dnl message.
dnl
dnl It defines the symbol MICOSETUP, MICOVERSION,  MICOSHAREDDIR MICO_INCLUDE,
dnl MICO_LIB, MICO_CXX and MICO_IDL if mico is found. In addition, the mico
dnl script mico-c++ (set in (MICO_CXX) is scaned for a string match
dnl "-I.*ministl" and if foundMICO_USE_MINISTL is set to 1, otherwise to 0.
dnl
dnl
dnl Example of use of these variables in your Makefile.in:
dnl
dnl   INCLUDES += @MICO_INCLUDE@
dnl   LDFLAGS += @MICO_LIB@
dnl
dnl @version $Id: ac_pkg_mico.m4,v 1.2 2000/07/19 13:03:32 simons Exp $
dnl @author Tal Shalif <tal@shalif.com>
dnl

AC_DEFUN([AC_PKG_MICO],
[
#
# first parse the argument given in configure.in to AC_PKG_MICO
#
MICO_REQUEST_VERSION=
MICO_URGENCY="optional"

changequote(<<, >>)

for a in $1 $2 $3 $4 $5 $6 $7 $8 $9 x; do
    case "$a" in
        x) break;;
        [0-9]*.[0-9]*.[0-9]*) MICO_REQUEST_VERSION="$a";;
        optional|required) MICO_URGENCY="$a";;
        *) AC_MSG_ERROR("argument to the PKG_MICO macro must be one of 'X.X.X' 'required' or 'optional'");;
    esac
done

changequote([, ])

AC_MSG_CHECKING(if mico is wanted)
AC_ARG_WITH(mico,
    [  --with-mico=DIR         base path name of mico's installation (default is to
                          search in \$prefix:/usr/local:/usr),
  --without-mico          to disable mico detection],
    [
    #
    # Run this if -with or -without was specified
    #
    case "$withval" in
        yes) MICO_URGENCY=required;;
        no) if test x$MICO_URGENCY = xrequired; then
                AC_MSG_ERROR("PKG_MICO was configured with the 'required' option. You can not override it from the command line")
            fi;
            ;;
        *) MICO_URGENCY=required; MICOSETUP="$withval/lib/mico-setup.sh" ;;
    esac

    ],[])

AC_MSG_RESULT($MICO_URGENCY)

#
# Now we know if we want mico or not, only go further if
# it's wanted.
#
if test x$MICO_URGENCY = xrequired -o  x$MICO_URGENCY = xoptional; then
    #
    # If not specified by caller, search in standard places
    #
    if test -z "$MICOSETUP" ; then
      AC_PATH_PROG(MICOSETUP, mico-setup.sh, , $prefix/lib:/usr/local/lib:/usr/lib)
    fi
    if test -z "$MICOSETUP" ; then
        if test x$MICO_URGENCY = xrequired ; then
            AC_MSG_ERROR("mico setup file mico-setup.sh not found")
        else
            AC_MSG_RESULT("mico setup file mico-setup.sh not found")
        fi
    else
        # source mico-setup.sh
        # Collect mico version number.
        # But be carefull - mico-setup.sh
        # unsets prefix and exec_prefix so save them first
        sh -c ". $MICOSETUP; echo MICOVERSION=\${MICOVERSION}; echo MICOSHAREDDIR=\${MICOSHAREDDIR}; echo MICODIR=\${MICODIR}" > conftest.mico-setup

        eval `cat conftest.mico-setup`

        if test -z "$MICOVERSION" ; then
            AC_MSG_ERROR("panic: could not read the MICOVERSION variable");
        fi
        #
        # Check that mico version matches requested version or above
        #
        if test -n "$MICO_REQUEST_VERSION" ; then
            changequote(<<, >>)dnl
            MICO_MAJOR=`expr $MICOVERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            MICO_MINOR=`expr $MICOVERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            MICO_RELEASE=`expr $MICOVERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            MICO_REQUEST_MAJOR=`expr $MICO_REQUEST_VERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            MICO_REQUEST_MINOR=`expr $MICO_REQUEST_VERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            MICO_REQUEST_RELEASE=`expr $MICO_REQUEST_VERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            changequote([, ])dnl

            AC_MSG_CHECKING(mico version >= $MICO_REQUEST_VERSION)

            version_ok=yes
            for verpair in "$MICO_MAJOR:$MICO_REQUEST_MAJOR" "$MICO_MINOR:$MICO_REQUEST_MINOR" "$MICO_RELEASE:$MICO_REQUEST_RELEASE"; do
                if eval "test `echo $verpair | sed 's,:, -gt ,'`"; then
                    break
                fi
                if eval "test `echo $verpair | sed 's,:, -lt ,'`"; then
                    version_ok=no
                    break
                fi
            done
            if test  x$version_ok = xno; then
                AC_MSG_RESULT(no)
                AC_MSG_ERROR(mico version is $MICOVERSION)
            else
                AC_MSG_RESULT(yes)
            fi
        fi
        #
        # look for mico-c++ and scan it for a string match
        # to "-I*ministl"
        #
        AC_PATH_PROG(MICO_CXX, mico-c++, , ${MICODIR}/bin:${MICOSHAREDDIR}/bin)
        if test -z "$MICO_CXX"; then
            AC_MSG_ERROR("panic: can not locate and scan the mico script mico-c++")
        fi

        #
        # look for mico idl and scan it for a string match
        #
        AC_PATH_PROG(MICO_IDL, idl, , ${MICODIR}/bin:${MICOSHAREDDIR}/bin)
        if test -z "$MICO_IDL"; then
            AC_MSG_ERROR("panic: can not locate and scan the mico idl program+")
        fi


        AC_MSG_CHECKING(if mico was compiled using ministl)

        if test -z "`grep -e '-I.*ministl' $MICO_CXX`"; then
            MICO_USE_MINISTL=0
            AC_MSG_RESULT(no)
        else
            MICO_USE_MINISTL=1
            AC_MSG_RESULT(yes)
        fi
        #
        # look for mico-ld and scan it for -l* libraries
        # needed to link with mico
        #
        AC_PATH_PROG(MICO_LD, mico-ld, , ${MICODIR}/bin:${MICOSHAREDDIR}/bin)

        if test -z "$MICO_LD"; then
            AC_MSG_ERROR("panic: can not locate and scan the mico script mico-ld")
        fi

        AC_MSG_CHECKING(mico dependencies)

        micodeps=
        for item in `grep -- -l $MICO_LD | tr '\"' ' '` ; do
            case $item in
                -l*) micodeps="$micodeps $item" ;;
            esac
        done

        if test -z "$micodeps" ;then
            AC_MSG_RESULT(none)
        else
            AC_MSG_RESULT($micodeps)
        fi

        AC_MSG_CHECKING(for mico qt library)
        if test -r ${MICODIR}/lib/libmicoqt${MICOVERSION}.a; then
           MICO_QTLIB="-lmicoqt${MICOVERSION}"
           AC_MSG_RESULT(${MICO_QTLIB})
        else
             AC_MSG_RESULT("mico qt library not found")
        fi

        AC_MSG_CHECKING(how to link with the mico library)
        MICO_LIB="-L${MICODIR}/lib -lmico${MICOVERSION} $micodeps"
        AC_MSG_RESULT($MICO_LIB)

        AC_MSG_CHECKING(for mico coss library)
        MICOCOSS_LIB="-L${MICODIR}/lib -lmicocoss${MICOVERSION} $micodeps"
        AC_MSG_RESULT($MICOCOSS_LIB)

        AC_MSG_CHECKING(how to link with the mico and micoqt library)
        MICO_QTLIB="-L${MICODIR}/lib -lmico${MICOVERSION} ${MICO_QTLIB} $micodeps"
        AC_MSG_RESULT($MICO_QTLIB)

        MICO_INCLUDE="-I${MICOSHAREDDIR}/include"
        
        MICO_CFLAGS="${MICO_INCLUDE} -DMICO"

        AC_SUBST(MICODIR)
        AC_SUBST(MICOVERSION)
        AC_SUBST(MICOSHAREDDIR)
        AC_SUBST(MICO_INCLUDE)
        AC_SUBST(MICO_CFLAGS)
        AC_SUBST(MICO_LIB)
        AC_SUBST(MICOCOSS_LIB)
        AC_SUBST(MICO_USE_MINISTL)
        AC_SUBST(MICO_QTLIB)
    fi
fi
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

