dnl Most of this borrowed from the mico m4 libaray ac_pkg_mico.m4 available
dnl from http://research.cys.de/autoconf-archive.
dnl and was written by  Tal Shalif <tal@shalif.com>
dnl
dnl @synopsis AC_PKG_XERCESC([X.X.X optional required])
dnl
dnl This file was created for the xmlBlaster project http://www.xmlBlaster.org
dnl
dnl This macro searches for a xerces-c installation on your system.
dnl xerces-cinstalls the file 'XercesDefs.hpp' under
dnl XERCESC_INSTALL_BASE/util, where XERCESC_INSTALL_BASE is probably
dnl /usr/local or /usr. If nothing was specified when calling configure
dnl or just --with-xerces-c, it searches in $prefix/util:/usr/local/util:/usr/util
dnl The argument of --with-xerces-c specifies the base pathname of the
dnl xerces-c installation. For instance --with-xerces-c=/usr/local/xerces-c-1.4.0
dnl
dnl If the version argument is given (e.g. 1.4.0), AC_PKG_XERCESC checks that the
dnl xerces-c package is this version number or higher.
dnl
dnl The other optional argument to AC_PKG_XERCESC are 'optional' and 'required'.
dnl by default, placing AC_PKG_XERCESC in your configure.in does not enforce
dnl using xerces-c, if it is not found on the system. If XERCESC existence is
dnl critical for the building of your package, then you probably want
dnl to specify something like "AC_PKG_XERCESC(1.4.0 required)". Then, even
dnl if the --with-xerces-c was not spcefied on the command line of the
dnl configure script, an error will be raised if xerces-c was not found.
dnl
dnl If the xerces-c package is not found, abort configuration with error
dnl message.
dnl
dnl It defines the symbol XERCESCDIR, XERCESCVERSION, XERCESC_INCLUDE, and
dnl XERCESC_LIB.
dnl
dnl Example of use of these variables in your Makefile.in:
dnl
dnl   INCLUDES += @XERCESC_INCLUDE@
dnl   LDFLAGS += @XERCESC_LIB@
dnl
dnl Author: Cory Bennett <coryb@sgi.com>


AC_DEFUN([AC_PKG_XERCESC],
[
#
# first parse the argument given in configure.in to AC_PKG_XERCESC
#
XERCESC_REQUEST_VERSION=
XERCESC_URGENCY="optional"

changequote(<<, >>)

for a in $1 $2 $3 $4 $5 $6 $7 $8 $9 x; do
    case "$a" in
        x) break;;
        [0-9]*.[0-9]*.[0-9]*) XERCESC_REQUEST_VERSION="$a";;
        optional|required) XERCESC_URGENCY="$a";;
        *) AC_MSG_ERROR("argument to the PKG_XERCESC macro must be one of 'X.X.X' 'required' or 'optional'");;
    esac
done

changequote([, ])

AC_MSG_CHECKING(if xerces-c is wanted)
AC_ARG_WITH(xerces-c,
    [  --with-xerces-c=DIR     base path name of xerces-c's installation (default is
                          to search in \$prefix:/usr/local:/usr),
  --without-xerces-c      to disable xerces-c detection],
    [
    #
    # Run this if -with or -without was specified
    #
    case "$withval" in
        yes) XERCESC_URGENCY=required;;
        no) if test x$XERCESC_URGENCY = xrequired; then
                AC_MSG_ERROR("PKG_XERCESC was configured with the 'required' option. You can not override it from the command line")
            fi;
            ;;
        *) XERCESC_URGENCY=required; XERCESCDIR="$withval"; XERCESC_DEF="$withval/util/XercesDefs.hpp" ;;
    esac

    ],[])

AC_MSG_RESULT($XERCESC_URGENCY)

#
# Now we know if we want xerces-c or not, only go further if
# it's wanted.
#
if test x$XERCESC_URGENCY = xrequired -o  x$XERCESC_URGENCY = xoptional; then
    #
    # If not specified by caller, search in standard places
    #
    if test -z "$XERCESC_DEF" ; then
      AC_PATH_PROG(XERCESC_DEF, XercesDefs.hpp, , $prefix/util:/usr/local/util:/usr/util)
      #
      # try to figure out the full path now.
      #
      XERCESCDIR="`echo \"$XERCESC_DEF\" | sed 's/\/util\/XercesDefs.hpp//'`"
      AC_MSG_RESULT( "xerces-c dir is $XERCESCDIR" )     
    else
      #
      # This is just to print out what we are doing
      # It does not actually do anything
      #
      AC_MSG_CHECKING(for XercesDefs.hpp)
      AC_MSG_RESULT($XERCESC_DEF)
    fi
    
    if test -z "$XERCESC_DEF" || ! test -f "$XERCESC_DEF"; then
        if test x$XERCESC_URGENCY = xrequired ; then
            AC_MSG_ERROR([xerces-c defs file XercesDefs.hpp not found,
use option --with-xerces-c=DIR if it is installed on your system.
If it is not installed on you system, then you can download it 
from http://xml.apache.org])
        else
            AC_MSG_RESULT("xerces-c defs file XercesDefs.hpp not found")
        fi
    else
        changequote(<<, >>)dnl
        XERCESCVERSION="`grep gXercesFullVersionStr $XERCESC_DEF | sed 's/^.*\"\([0-9][_0-9]*\).*$/\1/' | sed 's/_/./g'`"
        changequote([, ])dnl
        AC_MSG_RESULT( "Xerces-c Version is $XERCESCVERSION" )
        
        if test -z "$XERCESCVERSION" ; then
            AC_MSG_ERROR("panic: could not read the XERCESCVERSION variable");
        fi
        #
        # Check that xerces-c version matches requested version or above
        #
        if test -n "$XERCESC_REQUEST_VERSION" ; then
            changequote(<<, >>)dnl
            XERCESC_MAJOR=`expr $XERCESCVERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            XERCESC_MINOR=`expr $XERCESCVERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            XERCESC_RELEASE=`expr $XERCESCVERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            XERCESC_REQUEST_MAJOR=`expr $XERCESC_REQUEST_VERSION : '\([0-9]*\)\.[0-9]*\.[0-9]*'`
            XERCESC_REQUEST_MINOR=`expr $XERCESC_REQUEST_VERSION : '[0-9]*\.\([0-9]*\)\.[0-9]*'`
            XERCESC_REQUEST_RELEASE=`expr $XERCESC_REQUEST_VERSION : '[0-9]*\.[0-9]*\.\([0-9]*\)'`
            changequote([, ])dnl

            AC_MSG_CHECKING(xerces-c version >= $XERCESC_REQUEST_VERSION)

            version_ok=yes
            for verpair in "$XERCESC_MAJOR:$XERCESC_REQUEST_MAJOR" "$XERCESC_MINOR:$XERCESC_REQUEST_MINOR" "$XERCESC_RELEASE:$XERCESC_REQUEST_RELEASE"; do
                if eval "test `echo $verpair | sed 's,:, -gt ,'`"; then
                    break
                fi
                if eval "test `echo $verpair | sed 's,:, -lt ,'`"; then
                    version_ok=no
                    break
                fi
            done
            if test  x$version_ok = xno; then
                AC_MSG_RESULT(no)
                AC_MSG_ERROR(xerces-c version is $XERCESCVERSION)
            else
                AC_MSG_RESULT(yes)
            fi
        fi

        AC_MSG_CHECKING(how to link with the xerces-c library)

        changequote(<<, >>)dnl
        XERCESC_DLL_VERSION="`grep Xerces_DLLVersionStr $XERCESC_DEF | sed 's/^.*\"\([0-9][_0-9]*\).*$/\1/'`"
        changequote([, ])dnl
        if test ! -f "${XERCESCDIR}/lib/libxerces-c${XERCESC_DLL_VERSION}.so"; then
            AC_MSG_ERROR([xerces-c library libxerces-c${XERCESC_DLL_VERSION}.so not found])
        fi
        
        XERCESC_LIB="-L${XERCESCDIR}/lib -lxerces-c${XERCESC_DLL_VERSION}"
        AC_MSG_RESULT($XERCESC_LIB)
        
        if text -z "$XERCESC_INCLUDE"; then
            XERCESC_INCLUDE="$XERCESCDIR"
        fi
        
        AC_SUBST(XERCESCDIR)
        AC_SUBST(XERCESCVERSION)
        AC_SUBST(XERCESC_INCLUDE)
        AC_SUBST(XERCESC_LIB)
    fi
fi
])
